/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class ToolKitDAO {
    private static final Logger logger = Logger.getLogger(ToolKitDAO.class.getName());

    public void instalaBancoDeDados() throws NamingException, ConfigFailedException {
        this.instalaBancoDeDados(null);
    }

    public void instalaBancoDeDados(Properties props) throws NamingException, ConfigFailedException {
        if (props == null) {
            props = LexMLUtil.getJPAProperties();
        }
        if (null == props) {
            logger.error("Foi recebido um null no lugar das propriedades para o JPA.");
            throw new ConfigFailedException("Propriedades recebidas s\u00e3o podem ser nulas");
        }
        AnnotationConfiguration cfg = this.createAnnotationConfiguration(props);
        SchemaExport se = new SchemaExport(cfg);
        se.setOutputFile("lexml_create_ddl.sql");
        se.setDelimiter(";");
        se.create(true, true);
        List erros = se.getExceptions();
        if (!erros.isEmpty()) {
            logger.debug("Total de exce\u00e7\u00f5es durante a execu\u00e7\u00e3o da cria\u00e7\u00e3o do banco de dados" + erros.size());
            for (int i = 0; i < erros.size(); ++i) {
                Exception e = (Exception)erros.get(i);
                logger.error("[" + i + "] =" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaBancoDeDados(Properties props) {
        boolean ret = true;
        Connection conn = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            conn = this.openConnection(props);
            st = conn.prepareStatement("select count(*) from conjunto_item");
            rs = st.executeQuery();
        }
        catch (Exception e) {
            ret = false;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return ret;
    }

    protected AnnotationConfiguration createAnnotationConfiguration(Properties props) {
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.setProperties(props);
        cfg.addAnnotatedClass(RegistroItem.class);
        cfg.addAnnotatedClass(RegistroItemErro.class);
        cfg.addAnnotatedClass(TipoErro.class);
        cfg.addAnnotatedClass(ConjuntoItem.class);
        return cfg;
    }

    public void testaConexaoBancoDeDados(Properties p) throws Exception {
        Connection conn = this.openConnection(p);
        conn.commit();
        conn.close();
    }

    public Connection openConnection(String driver, String jdbcUrl, String usuario, String senha) throws Exception {
        Class.forName(driver);
        Connection conn = DriverManager.getConnection(jdbcUrl, usuario, senha);
        conn.setAutoCommit(false);
        return conn;
    }

    public Connection openConnection(Properties p) throws Exception {
        return this.openConnection(p.getProperty("hibernate.connection.driver_class"), p.getProperty("hibernate.connection.url"), p.getProperty("hibernate.connection.username"), p.getProperty("hibernate.connection.password"));
    }
}

