/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.DuplicateMappingException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.SecondPass;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mappings
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Mappings.class);
    protected final Map classes;
    protected final Map collections;
    protected final Map tables;
    protected final Map queries;
    protected final Map sqlqueries;
    protected final Map resultSetMappings;
    protected final Map typeDefs;
    protected final List secondPasses;
    protected final Map imports;
    protected String schemaName;
    protected String catalogName;
    protected String defaultCascade;
    protected String defaultPackage;
    protected String defaultAccess;
    protected boolean autoImport;
    protected boolean defaultLazy;
    protected final List propertyReferences;
    protected final NamingStrategy namingStrategy;
    protected final Map filterDefinitions;
    protected final List auxiliaryDatabaseObjects;
    protected final Map extendsQueue;
    protected final Map columnNameBindingPerTable;
    protected final Map tableNameBinding;

    Mappings(Map classes, Map collections, Map tables, Map queries, Map sqlqueries, Map sqlResultSetMappings, Map imports, List secondPasses, List propertyReferences, NamingStrategy namingStrategy, Map typeDefs, Map filterDefinitions, Map extendsQueue, List auxiliaryDatabaseObjects, Map tableNamebinding, Map columnNameBindingPerTable) {
        this.classes = classes;
        this.collections = collections;
        this.queries = queries;
        this.sqlqueries = sqlqueries;
        this.resultSetMappings = sqlResultSetMappings;
        this.tables = tables;
        this.imports = imports;
        this.secondPasses = secondPasses;
        this.propertyReferences = propertyReferences;
        this.namingStrategy = namingStrategy;
        this.typeDefs = typeDefs;
        this.filterDefinitions = filterDefinitions;
        this.extendsQueue = extendsQueue;
        this.auxiliaryDatabaseObjects = auxiliaryDatabaseObjects;
        this.tableNameBinding = tableNamebinding;
        this.columnNameBindingPerTable = columnNameBindingPerTable;
    }

    public void addClass(PersistentClass persistentClass) throws MappingException {
        PersistentClass old = this.classes.put(persistentClass.getEntityName(), persistentClass);
        if (old != null) {
            throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
        }
    }

    public void addCollection(Collection collection) throws MappingException {
        Collection old = this.collections.put(collection.getRole(), collection);
        if (old != null) {
            throw new DuplicateMappingException("collection role", collection.getRole());
        }
    }

    public PersistentClass getClass(String className) {
        return (PersistentClass)this.classes.get(className);
    }

    public Collection getCollection(String role) {
        return (Collection)this.collections.get(role);
    }

    public void addImport(String className, String rename) throws MappingException {
        String existing = this.imports.put(rename, className);
        if (existing != null) {
            if (existing.equals(className)) {
                log.info("duplicate import: " + className + "->" + rename);
            } else {
                throw new DuplicateMappingException("duplicate import: " + rename + " refers to both " + className + " and " + existing + " (try using auto-import=\"false\")", "import", rename);
            }
        }
    }

    public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract) {
        String key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setAbstract(isAbstract);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            table.setSubselect(subselect);
            this.tables.put(key, table);
        } else if (!isAbstract) {
            table.setAbstract(false);
        }
        return table;
    }

    public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable) throws MappingException {
        String key;
        String string = key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
        if (this.tables.containsKey(key)) {
            throw new DuplicateMappingException("table", name);
        }
        DenormalizedTable table = new DenormalizedTable(includedTable);
        table.setAbstract(isAbstract);
        table.setName(name);
        table.setSchema(schema);
        table.setCatalog(catalog);
        table.setSubselect(subselect);
        this.tables.put(key, table);
        return table;
    }

    public Table getTable(String schema, String catalog, String name) {
        String key = Table.qualify(catalog, schema, name);
        return (Table)this.tables.get(key);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setDefaultCascade(String defaultCascade) {
        this.defaultCascade = defaultCascade;
    }

    public void setDefaultAccess(String defaultAccess) {
        this.defaultAccess = defaultAccess;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public void addQuery(String name, NamedQueryDefinition query) throws MappingException {
        this.checkQueryExist(name);
        this.queries.put(name.intern(), query);
    }

    public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws MappingException {
        this.checkQueryExist(name);
        this.sqlqueries.put(name.intern(), query);
    }

    private void checkQueryExist(String name) throws MappingException {
        if (this.sqlqueries.containsKey(name) || this.queries.containsKey(name)) {
            throw new DuplicateMappingException("query", name);
        }
    }

    public void addResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) {
        String name = sqlResultSetMapping.getName();
        if (this.resultSetMappings.containsKey(name)) {
            throw new DuplicateMappingException("resultSet", name);
        }
        this.resultSetMappings.put(name, sqlResultSetMapping);
    }

    public ResultSetMappingDefinition getResultSetMapping(String name) {
        return (ResultSetMappingDefinition)this.resultSetMappings.get(name);
    }

    public NamedQueryDefinition getQuery(String name) {
        return (NamedQueryDefinition)this.queries.get(name);
    }

    public void addSecondPass(SecondPass sp) {
        this.addSecondPass(sp, false);
    }

    public void addSecondPass(SecondPass sp, boolean onTopOfTheQueue) {
        if (onTopOfTheQueue) {
            this.secondPasses.add(0, sp);
        } else {
            this.secondPasses.add(sp);
        }
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    void addUniquePropertyReference(String referencedClass, String propertyName) {
        PropertyReference upr = new PropertyReference();
        upr.referencedClass = referencedClass;
        upr.propertyName = propertyName;
        upr.unique = true;
        this.propertyReferences.add(upr);
    }

    void addPropertyReference(String referencedClass, String propertyName) {
        PropertyReference upr = new PropertyReference();
        upr.referencedClass = referencedClass;
        upr.propertyName = propertyName;
        this.propertyReferences.add(upr);
    }

    private String buildTableNameKey(String schema, String catalog, String finalName) {
        StringBuffer keyBuilder = new StringBuffer();
        if (schema != null) {
            keyBuilder.append(schema);
        }
        keyBuilder.append(".");
        if (catalog != null) {
            keyBuilder.append(catalog);
        }
        keyBuilder.append(".");
        keyBuilder.append(finalName);
        return keyBuilder.toString();
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void addTypeDef(String typeName, String typeClass, Properties paramMap) {
        TypeDef def = new TypeDef(typeClass, paramMap);
        this.typeDefs.put(typeName, def);
        log.debug("Added " + typeName + " with class " + typeClass);
    }

    public TypeDef getTypeDef(String typeName) {
        return (TypeDef)this.typeDefs.get(typeName);
    }

    public Iterator iterateCollections() {
        return this.collections.values().iterator();
    }

    public Iterator iterateTables() {
        return this.tables.values().iterator();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    public FilterDefinition getFilterDefinition(String name) {
        return (FilterDefinition)this.filterDefinitions.get(name);
    }

    public boolean isDefaultLazy() {
        return this.defaultLazy;
    }

    public void setDefaultLazy(boolean defaultLazy) {
        this.defaultLazy = defaultLazy;
    }

    public void addToExtendsQueue(ExtendsQueueEntry entry) {
        this.extendsQueue.put(entry, null);
    }

    public PersistentClass locatePersistentClassByEntityName(String entityName) {
        String actualEntityName;
        PersistentClass persistentClass = (PersistentClass)this.classes.get(entityName);
        if (persistentClass == null && StringHelper.isNotEmpty(actualEntityName = (String)this.imports.get(entityName))) {
            persistentClass = (PersistentClass)this.classes.get(actualEntityName);
        }
        return persistentClass;
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public void addTableBinding(String schema, String catalog, String logicalName, String physicalName, Table denormalizedSuperTable) {
        TableDescription tableDescription;
        String key = this.buildTableNameKey(schema, catalog, physicalName);
        TableDescription oldDescriptor = this.tableNameBinding.put(key, tableDescription = new TableDescription(logicalName, denormalizedSuperTable));
        if (oldDescriptor != null && !oldDescriptor.logicalName.equals(logicalName)) {
            throw new MappingException("Same physical table name reference several logical table names: " + physicalName + " => " + "'" + oldDescriptor.logicalName + "' and '" + logicalName + "'");
        }
    }

    public void addColumnBinding(String logicalName, Column finalColumn, Table table) {
        String oldFinalName;
        ColumnNames binding = (ColumnNames)this.columnNameBindingPerTable.get(table);
        if (binding == null) {
            binding = new ColumnNames();
            this.columnNameBindingPerTable.put(table, binding);
        }
        if ((oldFinalName = binding.logicalToPhysical.put(logicalName.toLowerCase(), finalColumn.getQuotedName())) != null && !(!finalColumn.isQuoted() ? oldFinalName.equalsIgnoreCase(finalColumn.getQuotedName()) : oldFinalName.equals(finalColumn.getQuotedName()))) {
            throw new MappingException("Same logical column name referenced by different physical ones: " + table.getName() + "." + logicalName + " => '" + oldFinalName + "' and '" + finalColumn.getQuotedName() + "'");
        }
        String oldLogicalName = binding.physicalToLogical.put(finalColumn.getQuotedName(), logicalName);
        if (oldLogicalName != null && !oldLogicalName.equals(logicalName)) {
            throw new MappingException("Same physical column represented by different logical column names: " + table.getName() + "." + finalColumn.getQuotedName() + " => '" + oldLogicalName + "' and '" + logicalName + "'");
        }
    }

    private String getLogicalTableName(String schema, String catalog, String physicalName) {
        String key = this.buildTableNameKey(schema, catalog, physicalName);
        TableDescription descriptor = (TableDescription)this.tableNameBinding.get(key);
        if (descriptor == null) {
            throw new MappingException("Unable to find physical table: " + physicalName);
        }
        return descriptor.logicalName;
    }

    public String getPhysicalColumnName(String logicalName, Table table) {
        logicalName = logicalName.toLowerCase();
        String finalName = null;
        Table currentTable = table;
        do {
            String key;
            TableDescription description;
            ColumnNames binding;
            if ((binding = (ColumnNames)this.columnNameBindingPerTable.get(currentTable)) != null) {
                finalName = (String)binding.logicalToPhysical.get(logicalName);
            }
            if ((description = (TableDescription)this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getSchema(), currentTable.getCatalog(), currentTable.getName()))) == null) continue;
            currentTable = description.denormalizedSupertable;
        } while (finalName == null && currentTable != null);
        if (finalName == null) {
            throw new MappingException("Unable to find column with logical name " + logicalName + " in table " + table.getName());
        }
        return finalName;
    }

    public String getLogicalColumnName(String physicalName, Table table) {
        String logical = null;
        Table currentTable = table;
        TableDescription description = null;
        do {
            String key;
            ColumnNames binding;
            if ((binding = (ColumnNames)this.columnNameBindingPerTable.get(currentTable)) != null) {
                logical = (String)binding.physicalToLogical.get(physicalName);
            }
            if ((description = (TableDescription)this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getSchema(), currentTable.getCatalog(), currentTable.getName()))) == null) continue;
            currentTable = description.denormalizedSupertable;
        } while (logical == null && currentTable != null && description != null);
        if (logical == null) {
            throw new MappingException("Unable to find logical column name from physical name " + physicalName + " in table " + table.getName());
        }
        return logical;
    }

    public String getLogicalTableName(Table table) {
        return this.getLogicalTableName(table.getQuotedSchema(), table.getCatalog(), table.getQuotedName());
    }

    public static class TableDescription
    implements Serializable {
        public String logicalName;
        public Table denormalizedSupertable;

        public TableDescription(String logicalName, Table denormalizedSupertable) {
            this.logicalName = logicalName;
            this.denormalizedSupertable = denormalizedSupertable;
        }
    }

    public static class ColumnNames
    implements Serializable {
        public Map logicalToPhysical = new HashMap();
        public Map physicalToLogical = new HashMap();
    }

    static final class PropertyReference
    implements Serializable {
        String referencedClass;
        String propertyName;
        boolean unique;

        PropertyReference() {
        }
    }
}

