/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;

    public Message(Expression expression, Expression expression2) {
        this.terminate = expression2;
        this.select = expression;
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        if (this.terminate != null) {
            this.terminate = this.terminate.simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = this.terminate.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = this.terminate.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public int getInstructionNameCode() {
        return 158;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return EmptySequenceTest.getInstance();
    }

    public int getCardinality() {
        return 8192;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, promotionOffer);
        }
        if (this.terminate != null) {
            this.terminate = this.doPromotion(this.terminate, promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        if (this.terminate != null) {
            arrayList.add(this.terminate);
        }
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.terminate == expression) {
            this.terminate = expression2;
            bl = true;
        }
        return bl;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Object object;
        Controller controller = xPathContext.getController();
        Receiver receiver = controller.getMessageEmitter();
        TreeReceiver treeReceiver = new TreeReceiver(receiver);
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        xPathContextMinor.changeOutputDestination(properties, treeReceiver, false, 50, 3, null);
        boolean bl = false;
        if (this.terminate != null && !((String)(object = this.terminate.evaluateAsString(xPathContext))).equals("no")) {
            if (((String)object).equals("yes")) {
                bl = true;
            } else {
                DynamicError dynamicError = new DynamicError("The terminate attribute of xsl:message must be 'yes' or 'no'");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XTDE0030");
                throw dynamicError;
            }
        }
        treeReceiver.startDocument(bl ? 16384 : 0);
        if (this.select != null) {
            Item item;
            object = this.select.iterate(xPathContextMinor);
            while ((item = object.next()) != null) {
                treeReceiver.append(item, this.locationId, 2);
            }
        }
        treeReceiver.endDocument();
        if (bl) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber() + " in " + ExpressionLocation.truncateURI(this.getSystemId()));
        }
        return null;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "message");
    }
}

