/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.EmptyGreatestComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class SortKeyDefinition
implements Serializable {
    private static StringLiteral defaultOrder = new StringLiteral("ascending");
    private static StringLiteral defaultCaseOrder = new StringLiteral("#default");
    private static StringLiteral defaultLanguage = new StringLiteral(StringValue.EMPTY_STRING);
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = null;
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Expression stable = null;
    protected StringCollator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    protected Container parentExpression;
    private transient AtomicComparer finalComparator = null;

    public void setParentExpression(Container container) {
        this.parentExpression = container;
    }

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public void setSortKey(Expression expression) {
        this.sortKey = expression;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression expression) {
        this.order = expression;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression expression) {
        this.dataTypeExpression = expression;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder = expression;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression expression) {
        this.language = expression;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationNameExpression(Expression expression) {
        this.collationName = expression;
    }

    public Expression getCollationNameExpression() {
        return this.collationName;
    }

    public void setCollation(StringCollator stringCollator) {
        this.collation = stringCollator;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression expression) {
        this.stable = expression;
    }

    public Expression getStable() {
        return this.stable;
    }

    public void setBackwardsCompatible(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean bl) {
        this.emptyLeast = bl;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order instanceof Literal) || this.dataTypeExpression != null && !(this.dataTypeExpression instanceof Literal) || !(this.caseOrder instanceof Literal) || !(this.language instanceof Literal) || this.stable != null && !(this.stable instanceof Literal) || this.collationName != null && !(this.collationName instanceof Literal));
    }

    public SortKeyDefinition simplify(StaticContext staticContext, Executable executable) throws XPathException {
        this.sortKey = this.sortKey.simplify(staticContext);
        this.order = this.order.simplify(staticContext);
        if (this.dataTypeExpression != null) {
            this.dataTypeExpression = this.dataTypeExpression.simplify(staticContext);
        }
        this.caseOrder = this.caseOrder.simplify(staticContext);
        this.language = this.language.simplify(staticContext);
        if (this.stable != null) {
            this.stable = this.stable.simplify(staticContext);
        }
        return this;
    }

    public AtomicComparer makeComparator(XPathContext xPathContext) throws XPathException {
        Serializable serializable;
        Object object;
        Object object2;
        StringCollator stringCollator;
        String string = this.order.evaluateAsString(xPathContext);
        Configuration configuration = xPathContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (this.collation != null) {
            stringCollator = this.collation;
        } else {
            if (this.collationName != null) {
                object2 = this.collationName.evaluateAsString(xPathContext);
                try {
                    object = new URI((String)object2);
                    if (!((URI)object).isAbsolute()) {
                        if (this.baseURI == null) {
                            throw new DynamicError("Collation URI is relative, and base URI is unknown");
                        }
                        serializable = new URI(this.baseURI);
                        object = ((URI)serializable).resolve((URI)object);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DynamicError("Collation name " + (String)object2 + " is not a valid URI: " + uRISyntaxException);
                }
                try {
                    stringCollator = xPathContext.getCollation(((URI)object).toString());
                }
                catch (XPathException xPathException) {
                    if ("FOCH0002".equals(xPathException.getErrorCodeLocalPart())) {
                        xPathException.setErrorCode("XTDE1035");
                    }
                    throw xPathException;
                }
            }
            object2 = this.caseOrder.evaluateAsString(xPathContext);
            object = this.language.evaluateAsString(xPathContext);
            serializable = new Properties();
            if (!((String)object).equals("")) {
                ((Properties)serializable).setProperty("lang", (String)object);
            }
            if (!((String)object2).equals("#default")) {
                ((Properties)serializable).setProperty("case-order", (String)object2);
            }
            stringCollator = Configuration.getPlatform().makeCollation(configuration, (Properties)serializable, "");
        }
        AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, this.sortKey.getItemType(typeHierarchy).getAtomizedItemType().getPrimitiveType(), xPathContext);
        if (this.dataTypeExpression == null) {
            if (!this.emptyLeast) {
                atomicComparer = new EmptyGreatestComparer(atomicComparer);
            }
        } else {
            object2 = this.dataTypeExpression.evaluateAsString(xPathContext);
            if (((String)object2).equals("text")) {
                atomicComparer = new TextComparer(atomicComparer);
            } else if (((String)object2).equals("number")) {
                atomicComparer = NumericComparer.getInstance();
            } else {
                object = new DynamicError("data-type on xsl:sort must be 'text' or 'number'");
                ((XPathException)object).setErrorCode("XTDE0030");
                throw object;
            }
        }
        if (this.stable != null && !((String)(object = ((StringValue)(object2 = (StringValue)this.stable.evaluateItem(xPathContext))).getStringValue().trim())).equals("yes") && !((String)object).equals("no")) {
            serializable = new DynamicError("Value of 'stable' on xsl:sort must be 'yes' or 'no'");
            ((XPathException)serializable).setErrorCode("XTDE0030");
            throw serializable;
        }
        if (string.equals("ascending")) {
            return atomicComparer;
        }
        if (string.equals("descending")) {
            return new DescendingComparer(atomicComparer);
        }
        object2 = new DynamicError("order must be 'ascending' or 'descending'");
        ((XPathException)object2).setErrorCode("XTDE0030");
        throw object2;
    }

    public void setFinalComparator(AtomicComparer atomicComparer) {
        this.finalComparator = atomicComparer;
    }

    public AtomicComparer getFinalComparator() {
        return this.finalComparator;
    }
}

