/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Assign;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;

public class SaxonAssign
extends XSLGeneralVariable {
    private XSLVariableDeclaration declaration;
    private Assign instruction = new Assign();

    public boolean isInstruction() {
        return true;
    }

    public boolean isAssignable() {
        return true;
    }

    protected boolean allowsAsAttribute() {
        return false;
    }

    public void validate() throws XPathException {
        super.validate();
        try {
            this.declaration = this.bindVariable(this.getVariableFingerprint());
            this.declaration.registerReference(this.instruction);
            this.requiredType = this.declaration.getRequiredType();
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
            return;
        }
        if (!this.declaration.isAssignable()) {
            this.compileError("Variable " + this.getVariableName() + " is not marked as assignable");
        }
        if (!this.declaration.isGlobal()) {
            this.compileError("saxon:assign now works only with global variables");
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        this.initializeInstruction(executable, this.instruction);
        ExpressionTool.makeParentReferences(this.instruction);
        return this.instruction;
    }
}

