/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;

public final class XPathVariable
implements VariableDeclaration,
Binding,
Serializable {
    private QNameValue name;
    private Configuration config;
    private int slotNumber;

    private XPathVariable() {
    }

    protected static XPathVariable make(QNameValue qNameValue, Configuration configuration) {
        XPathVariable xPathVariable = new XPathVariable();
        xPathVariable.name = qNameValue;
        xPathVariable.config = configuration;
        return xPathVariable;
    }

    public boolean isGlobal() {
        return true;
    }

    public final boolean isAssignable() {
        return false;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public QNameValue getVariableQName() {
        return this.name;
    }

    public String getVariableName() {
        return this.name.toString();
    }

    public int getNameCode() {
        return this.name.allocateNameCode(this.config.getNamePool());
    }

    public void registerReference(BindingReference bindingReference) {
        bindingReference.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        bindingReference.fixup(this);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

