/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreWriter;

public class HackedTinyBuilder
extends Builder {
    private PackedByteBuf textBuf = new PackedByteBuf(1000);
    private StructuredStore treeStore;
    private SubStoreWriter textStore;
    public static final int PARENT_POINTER_INTERVAL = Integer.MAX_VALUE;
    private TinyTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private int[] sizeParameters;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];
    private boolean isIDElement = false;

    public void setTreeStore(StructuredStore treeStore) {
        this.treeStore = treeStore;
    }

    public StructuredStore getTreeStore() {
        return this.treeStore;
    }

    public void setTextStore(SubStoreWriter textStore) {
        this.textStore = textStore;
    }

    public SubStoreWriter getTextStore() {
        return this.textStore;
    }

    public void setSizeParameters(int[] params) {
        this.sizeParameters = params;
    }

    public int[] getSizeParameters() {
        int[] params = new int[]{this.tree.getNumberOfNodes(), this.tree.getNumberOfAttributes(), this.tree.getNumberOfNamespaces(), this.tree.getCharacterBuffer().length()};
        return params;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public void open() throws XPathException {
        if (this.started) {
            return;
        }
        if (this.tree == null) {
            this.tree = this.sizeParameters == null ? new TinyTree() : new TinyTree(this.sizeParameters[0], this.sizeParameters[1], this.sizeParameters[2], this.sizeParameters[3]);
            this.tree.setConfiguration(this.config);
            this.currentDepth = 0;
            if (this.lineNumbering) {
                this.tree.setLineNumbering();
            }
        }
        super.open();
    }

    public void startDocument(int properties) throws XPathException {
        if (this.started && !this.ended || this.currentDepth > 0) {
            return;
        }
        this.started = true;
        this.ended = false;
        this.currentRoot = new TinyDocumentImpl(this.tree);
        TinyDocumentImpl doc = (TinyDocumentImpl)this.currentRoot;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        doc.setConfiguration(this.config);
        this.currentDepth = 0;
        this.tree.addDocumentNode((TinyDocumentImpl)this.currentRoot);
        this.prevAtDepth[0] = 0;
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        this.tree.next[0] = -1;
        ++this.currentDepth;
        super.startDocument(0);
    }

    public void endDocument() throws XPathException {
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void close() throws XPathException {
        this.tree.addNode((short)11, 0, 0, 0, -1);
        this.tree.condense();
        super.close();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        int prev;
        if (this.siblingsAtDepth[this.currentDepth] > Integer.MAX_VALUE) {
            this.nodeNr = this.tree.addNode((short)12, this.currentDepth, this.prevAtDepth[this.currentDepth - 1], 0, 0);
            prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        this.nodeNr = this.tree.addNode((short)1, this.currentDepth, -1, -1, nameCode);
        boolean bl = this.isIDElement = (properties & 0x800) != 0;
        if (typeCode != 630 && typeCode != -1) {
            this.tree.setElementAnnotation(this.nodeNr, typeCode);
            if (!this.isIDElement && this.config.getTypeHierarchy().isIdCode(typeCode)) {
                this.isIDElement = true;
            }
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = this.tree.getNode(this.nodeNr);
        } else {
            prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, p2, 0, this.currentDepth);
            this.prevAtDepth = p2;
            p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.siblingsAtDepth, 0, p2, 0, this.currentDepth);
            this.siblingsAtDepth = p2;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        LocationProvider locator = this.pipe.getLocationProvider();
        if (locator instanceof SourceLocationProvider) {
            this.tree.setSystemId(this.nodeNr, locator.getSystemId(locationId));
            if (this.lineNumbering) {
                this.tree.setLineNumber(this.nodeNr, locator.getLineNumber(locationId));
            }
        } else if (this.currentDepth == 1) {
            this.tree.setSystemId(this.nodeNr, this.systemId);
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        this.tree.addNamespace(this.nodeNr, namespaceCode);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.tree.addAttribute(this.currentRoot, this.nodeNr, nameCode, typeCode, value, properties);
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws XPathException {
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
        if (this.isIDElement) {
            this.tree.indexIDElement(this.currentRoot, this.prevAtDepth[this.currentDepth], this.config.getNameChecker());
            this.isIDElement = false;
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int len = chars.length();
        if (len > 0) {
            long startPos;
            this.textBuf.reset();
            this.textBuf.writeCharSequence(chars);
            try {
                startPos = this.textStore.length();
                this.textBuf.output(this.textStore);
            }
            catch (IOException e) {
                throw new DynamicError(e);
            }
            this.nodeNr = this.tree.addNode((short)3, this.currentDepth, (int)startPos, this.textBuf.length(), -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                this.tree.next[prev] = this.nodeNr;
            }
            this.tree.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
    }

    public void processingInstruction(String piname, CharSequence remainder, int locationId, int properties) throws XPathException {
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    public void setUnparsedEntity(String name, String uri, String publicId) {
        ((TinyDocumentImpl)this.currentRoot).setUnparsedEntity(name, uri, publicId);
    }
}

