/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class BigIntegerValue
extends IntegerValue {
    private BigInteger value;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final BigIntegerValue ZERO = new BigIntegerValue(BigInteger.ZERO);

    public BigIntegerValue(BigInteger bigInteger) {
        this.value = bigInteger;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public BigIntegerValue(BigInteger bigInteger, AtomicType atomicType) {
        this.value = bigInteger;
        this.typeLabel = atomicType;
    }

    public BigIntegerValue(long l) {
        this.value = BigInteger.valueOf(l);
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public AtomicValue copy(AtomicType atomicType) {
        BigIntegerValue bigIntegerValue = new BigIntegerValue(this.value);
        bigIntegerValue.typeLabel = atomicType;
        return bigIntegerValue;
    }

    public ValidationException convertToSubType(AtomicType atomicType, boolean bl) {
        if (!bl) {
            this.typeLabel = atomicType;
            return null;
        }
        if (IntegerValue.checkBigRange(this.value, atomicType)) {
            this.typeLabel = atomicType;
            return null;
        }
        ValidationException validationException = new ValidationException("Integer value is out of range for subtype " + atomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return validationException;
    }

    public int hashCode() {
        if (this.value.compareTo(MIN_INT) >= 0 && this.value.compareTo(MAX_INT) <= 0) {
            return this.value.intValue();
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger asBigInteger() {
        return this.value;
    }

    public boolean isWithinLongRange() {
        return this.value.compareTo(MIN_LONG) >= 0 && this.value.compareTo(MAX_LONG) <= 0;
    }

    public BigDecimal asDecimal() {
        return new BigDecimal(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value.compareTo(BigInteger.ZERO) != 0;
    }

    public int compareTo(Object object) {
        if (object instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)object).value);
        }
        if (object instanceof DecimalValue) {
            return this.asDecimal().compareTo(((DecimalValue)object).getDecimalValue());
        }
        return super.compareTo(object);
    }

    public int compareTo(long l) {
        if (l == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigInteger.valueOf(l));
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue());
            }
            case 88: 
            case 532: 
            case 632: 
            case 635: {
                return this;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 542: 
            case 543: 
            case 544: {
                if (this.isWithinLongRange()) {
                    Int64Value int64Value = Int64Value.makeIntegerValue(this.longValue());
                    ValidationException validationException = int64Value.convertToSubType(builtInAtomicType, bl);
                    if (validationException == null) {
                        return int64Value;
                    }
                    return new ValidationErrorValue(validationException);
                }
                BigIntegerValue bigIntegerValue = new BigIntegerValue(this.value);
                ValidationException validationException = bigIntegerValue.convertToSubType(builtInAtomicType, bl);
                if (validationException == null) {
                    return bigIntegerValue;
                }
                return new ValidationErrorValue(validationException);
            }
            case 541: {
                if (this.value.signum() < 0 || this.value.bitLength() > 64) {
                    ValidationException validationException = new ValidationException("Integer value is out of range for type " + builtInAtomicType.getDisplayName());
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                if (this.isWithinLongRange()) {
                    Int64Value int64Value = Int64Value.makeIntegerValue(this.longValue());
                    ValidationException validationException = int64Value.convertToSubType(builtInAtomicType, bl);
                    if (validationException != null) {
                        return new ValidationErrorValue(validationException);
                    }
                    return int64Value;
                }
                BigIntegerValue bigIntegerValue = new BigIntegerValue(this.value);
                ValidationException validationException = bigIntegerValue.convertToSubType(builtInAtomicType, bl);
                if (validationException != null) {
                    return new ValidationErrorValue(validationException);
                }
                return bigIntegerValue;
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 515: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert integer to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal getDecimalValue() {
        return new BigDecimal(this.value);
    }

    public NumericValue negate() {
        return new BigIntegerValue(this.value.negate());
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundHalfToEven(int n) {
        if (n >= 0) {
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(10L).pow(-n);
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(bigInteger);
        int n2 = bigIntegerArray[1].compareTo(bigInteger.divide(BigInteger.valueOf(2L)));
        if (n2 > 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        } else if (n2 == 0 && bigIntegerArray[0].mod(BigInteger.valueOf(2L)).signum() != 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeIntegerValue(bigIntegerArray[0].multiply(bigInteger));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof BigIntegerValue) {
            BigInteger bigInteger = ((BigIntegerValue)numericValue).value;
            switch (n) {
                case 15: {
                    return BigIntegerValue.makeIntegerValue(this.value.add(bigInteger));
                }
                case 16: {
                    return BigIntegerValue.makeIntegerValue(this.value.subtract(bigInteger));
                }
                case 17: {
                    return BigIntegerValue.makeIntegerValue(this.value.multiply(bigInteger));
                }
                case 50: {
                    try {
                        return BigIntegerValue.makeIntegerValue(this.value.divide(bigInteger));
                    }
                    catch (ArithmeticException arithmeticException) {
                        DynamicError dynamicError;
                        if ("/ by zero".equals(arithmeticException.getMessage())) {
                            dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                        } else {
                            dynamicError = new DynamicError("Integer division failure", arithmeticException);
                        }
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                case 18: {
                    DecimalValue decimalValue = new DecimalValue(new BigDecimal(this.value));
                    DecimalValue decimalValue2 = new DecimalValue(new BigDecimal(bigInteger));
                    return decimalValue.arithmetic(n, decimalValue2, xPathContext);
                }
                case 19: {
                    return BigIntegerValue.makeIntegerValue(this.value.remainder(bigInteger));
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof Int64Value) {
            BigIntegerValue bigIntegerValue = new BigIntegerValue(numericValue.longValue());
            return this.arithmetic(n, bigIntegerValue, xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public IntegerValue plus(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.add(((BigIntegerValue)integerValue).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.add(BigInteger.valueOf(((Int64Value)integerValue).longValue())));
    }

    public IntegerValue minus(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.subtract(((BigIntegerValue)integerValue).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.subtract(BigInteger.valueOf(((Int64Value)integerValue).longValue())));
    }

    public IntegerValue times(IntegerValue integerValue) {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.multiply(((BigIntegerValue)integerValue).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.multiply(BigInteger.valueOf(((Int64Value)integerValue).longValue())));
    }

    public NumericValue div(IntegerValue integerValue) throws XPathException {
        BigInteger bigInteger = integerValue instanceof BigIntegerValue ? ((BigIntegerValue)integerValue).value : BigInteger.valueOf(((Int64Value)integerValue).longValue());
        DecimalValue decimalValue = new DecimalValue(new BigDecimal(this.value));
        DecimalValue decimalValue2 = new DecimalValue(new BigDecimal(bigInteger));
        return (NumericValue)Calculator.DECIMAL_DECIMAL[3].compute(decimalValue, decimalValue2, null);
    }

    public IntegerValue mod(IntegerValue integerValue) throws XPathException {
        if (integerValue instanceof BigIntegerValue) {
            return BigIntegerValue.makeIntegerValue(this.value.remainder(((BigIntegerValue)integerValue).value));
        }
        return BigIntegerValue.makeIntegerValue(this.value.remainder(BigInteger.valueOf(((Int64Value)integerValue).longValue())));
    }

    public IntegerValue idiv(IntegerValue integerValue) throws XPathException {
        BigInteger bigInteger = integerValue instanceof BigIntegerValue ? ((BigIntegerValue)integerValue).value : BigInteger.valueOf(((Int64Value)integerValue).longValue());
        try {
            return BigIntegerValue.makeIntegerValue(this.value.divide(bigInteger));
        }
        catch (ArithmeticException arithmeticException) {
            DynamicError dynamicError = "/ by zero".equals(arithmeticException.getMessage()) ? new DynamicError("Integer division by zero", "FOAR0001") : new DynamicError("Integer division failure", arithmeticException);
            throw dynamicError;
        }
    }

    public Value reduce() throws XPathException {
        if (this.compareTo(Long.MAX_VALUE) < 0 && this.compareTo(Long.MIN_VALUE) > 0) {
            Int64Value int64Value = new Int64Value(this.longValue());
            int64Value.setTypeLabel(this.typeLabel);
            return int64Value;
        }
        return this;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (this.isWithinLongRange()) {
            Int64Value int64Value = Int64Value.makeIntegerValue(this.longValue());
            return int64Value.convertToJava(clazz, xPathContext);
        }
        if (clazz.isAssignableFrom(Int64Value.class)) {
            return this;
        }
        if (clazz == BigInteger.class) {
            return this.value;
        }
        return this.convert(BuiltInAtomicType.DECIMAL, xPathContext).convertToJava(clazz, xPathContext);
    }
}

