/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ValidationErrorValue;

public abstract class NumericValue
extends AtomicValue
implements Comparable {
    public static NumericValue parseNumber(String string) {
        if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
            try {
                return new DoubleValue(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                return DoubleValue.NaN;
            }
        }
        if (string.indexOf(46) >= 0) {
            AtomicValue atomicValue = DecimalValue.makeDecimalValue(string, true);
            if (atomicValue instanceof ValidationErrorValue) {
                return DoubleValue.NaN;
            }
            return (NumericValue)atomicValue;
        }
        AtomicValue atomicValue = Int64Value.stringToInteger(string);
        if (atomicValue instanceof ValidationErrorValue) {
            return DoubleValue.NaN;
        }
        return (NumericValue)atomicValue;
    }

    public double getDoubleValue() {
        try {
            return ((DoubleValue)this.convert(BuiltInAtomicType.DOUBLE, null)).getDoubleValue();
        }
        catch (XPathException xPathException) {
            return Double.NaN;
        }
    }

    public float getFloatValue() {
        try {
            return ((FloatValue)this.convert(BuiltInAtomicType.FLOAT, null)).getFloatValue();
        }
        catch (XPathException xPathException) {
            return Float.NaN;
        }
    }

    public BigDecimal getDecimalValue() throws XPathException {
        return ((DecimalValue)this.convert(BuiltInAtomicType.DECIMAL, null)).getDecimalValue();
    }

    public boolean isNaN() {
        return false;
    }

    public static boolean isInteger(AtomicValue atomicValue) {
        return atomicValue instanceof IntegerValue;
    }

    public long longValue() throws XPathException {
        return ((Int64Value)this.convert(BuiltInAtomicType.INTEGER, null)).longValue();
    }

    public abstract NumericValue negate();

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round();

    public abstract NumericValue roundHalfToEven(int var1);

    public abstract double signum();

    public abstract NumericValue arithmetic(int var1, NumericValue var2, XPathContext var3) throws XPathException;

    public abstract boolean isWholeNumber();

    public Comparable getXPathComparable() {
        return this;
    }

    public int compareTo(Object object) {
        double d;
        if (!(object instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + object.getClass());
        }
        double d2 = this.getDoubleValue();
        if (d2 == (d = ((NumericValue)object).getDoubleValue())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public abstract int compareTo(long var1);

    public final boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static ItemType promote(ItemType itemType, ItemType itemType2, TypeHierarchy typeHierarchy) {
        ItemType itemType3;
        ItemType itemType4 = typeHierarchy.isSubType(itemType, BuiltInAtomicType.NUMERIC) ? itemType : BuiltInAtomicType.DOUBLE;
        ItemType itemType5 = itemType3 = typeHierarchy.isSubType(itemType2, BuiltInAtomicType.NUMERIC) ? itemType2 : BuiltInAtomicType.DOUBLE;
        if (itemType4 == itemType3) {
            return itemType4;
        }
        if (itemType4.equals(BuiltInAtomicType.DOUBLE) || itemType3.equals(BuiltInAtomicType.DOUBLE)) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (itemType4.equals(BuiltInAtomicType.FLOAT) || itemType3.equals(BuiltInAtomicType.FLOAT)) {
            return BuiltInAtomicType.FLOAT;
        }
        if (itemType4.equals(BuiltInAtomicType.DECIMAL) || itemType3.equals(BuiltInAtomicType.DECIMAL)) {
            return BuiltInAtomicType.DECIMAL;
        }
        return BuiltInAtomicType.INTEGER;
    }

    public abstract int hashCode();

    public String toString() {
        return this.getStringValue();
    }
}

