/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bigram;

import java.util.Set;
import org.apache.lucene.bigram.BigramQueryRewriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanWildcardQuery;

public class BigramSpanWildcardQuery
extends SpanWildcardQuery {
    private Set stopSet;

    public BigramSpanWildcardQuery(Term term, int termLimit) {
        super(term, termLimit);
    }

    public void setStopWords(Set set) {
        this.stopSet = set;
    }

    protected boolean shouldSkipTerm(Term term) {
        if (this.stopSet == null) {
            return false;
        }
        if (this.stopSet.contains(term.text())) {
            return true;
        }
        return BigramQueryRewriter.isBigram(this.stopSet, term.text());
    }
}

