/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.chunk.Chunk;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.index.IndexReader;

public class ChunkSource {
    protected IndexReader reader;
    protected DocNumMap docNumMap;
    protected int mainDocNum;
    protected int chunkSize;
    protected int chunkOverlap;
    protected int chunkBump;
    protected int firstChunk;
    protected int lastChunk;
    protected String field;
    protected Analyzer analyzer;
    protected LinkedList chunkCache = new LinkedList();
    protected int chunkCacheSize = 10;

    public ChunkSource(IndexReader reader, DocNumMap docNumMap, int mainDocNum, String field, Analyzer analyzer) {
        this.reader = reader;
        this.docNumMap = docNumMap;
        this.mainDocNum = mainDocNum;
        this.field = field;
        this.analyzer = analyzer;
        this.chunkSize = docNumMap.getChunkSize();
        this.chunkOverlap = docNumMap.getChunkOverlap();
        this.chunkBump = this.chunkSize - this.chunkOverlap;
        this.firstChunk = docNumMap.getFirstChunk(mainDocNum);
        this.lastChunk = docNumMap.getLastChunk(mainDocNum);
    }

    protected Chunk createChunkTokens(int chunkNum) {
        return new Chunk(this, chunkNum);
    }

    public boolean inMainDoc(int chunkNum) {
        if (chunkNum < this.firstChunk) {
            return false;
        }
        if (chunkNum > this.lastChunk) {
            return false;
        }
        return !this.reader.isDeleted(chunkNum);
    }

    protected void loadText(int chunkNum, Chunk chunk) throws IOException {
        chunk.text = this.reader.document(chunkNum).get(this.field);
    }

    public Chunk loadChunk(int chunkNum) {
        try {
            Token t;
            for (Chunk c : this.chunkCache) {
                if (c.chunkNum != chunkNum) continue;
                return c;
            }
            Chunk chunk = this.createChunkTokens(chunkNum);
            chunk.minWordPos = (chunkNum - this.firstChunk) * this.chunkBump;
            chunk.maxWordPos = chunk.minWordPos - 1;
            this.loadText(chunkNum, chunk);
            TokenStream stream = this.analyzer.tokenStream(this.field, new StringReader(chunk.text));
            ArrayList<Token> tokenList = new ArrayList<Token>(10);
            int wordPos = chunk.maxWordPos;
            while ((t = stream.next()) != null) {
                if (chunkNum < this.lastChunk && (wordPos += t.getPositionIncrement()) >= chunk.minWordPos + this.chunkBump) {
                    chunk.text = chunk.text.substring(0, t.startOffset());
                    break;
                }
                tokenList.add(t);
                chunk.maxWordPos = wordPos;
            }
            stream.close();
            chunk.tokens = tokenList.toArray(new Token[tokenList.size()]);
            if (this.chunkCache.size() == this.chunkCacheSize) {
                this.chunkCache.removeFirst();
            }
            this.chunkCache.add(chunk);
            return chunk;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getChunkOverlap() {
        return this.chunkOverlap;
    }
}

