/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import org.apache.lucene.chunk.Chunk;
import org.apache.lucene.chunk.ChunkMarkPos;
import org.apache.lucene.chunk.ChunkSource;
import org.apache.lucene.mark.BasicWordIter;
import org.apache.lucene.mark.MarkPos;

public class ChunkedWordIter
extends BasicWordIter
implements Cloneable {
    protected ChunkSource chunkSource;
    protected Chunk chunk;

    public ChunkedWordIter(ChunkSource chunkSource) {
        this.chunkSource = chunkSource;
    }

    public boolean next(boolean force) {
        if (this.tokens == null) {
            this.reseek(0);
        } else if (this.tokNum == this.tokens.length - 1) {
            int initialGap;
            Chunk next;
            while (true) {
                if (!this.chunkSource.inMainDoc(this.chunk.chunkNum + 1)) {
                    return false;
                }
                next = this.chunkSource.loadChunk(this.chunk.chunkNum + 1);
                if (next.tokens.length != 0) break;
                if (!force) {
                    return false;
                }
                this.chunk = next;
            }
            if (!force && (initialGap = next.tokens[0].getPositionIncrement() - 1) >= this.chunkSource.getChunkOverlap()) {
                return false;
            }
            this.reseek(next);
            return true;
        }
        return super.next(force);
    }

    public boolean prev(boolean force) {
        if (this.tokens == null) {
            return false;
        }
        if (this.tokNum == 0) {
            Chunk prev;
            while (true) {
                int initialGap;
                if (!this.chunkSource.inMainDoc(this.chunk.chunkNum - 1)) {
                    return false;
                }
                if (!force && (initialGap = this.wordPos - this.chunk.minWordPos) >= this.chunk.source.getChunkOverlap()) {
                    return false;
                }
                prev = this.chunkSource.loadChunk(this.chunk.chunkNum - 1);
                if (prev.tokens.length != 0) break;
                if (!force) {
                    return false;
                }
                this.chunk = prev;
            }
            this.reseek(prev);
            while (this.wordPos < this.chunk.maxWordPos) {
                super.next(true);
            }
            return true;
        }
        return super.prev(force);
    }

    protected void reseek(int targetPos) {
        if (this.chunk != null && targetPos >= this.chunk.minWordPos && targetPos < this.chunk.maxWordPos) {
            return;
        }
        int targetChunk = targetPos / this.chunkSource.chunkBump + this.chunkSource.firstChunk;
        if (targetChunk == this.chunkSource.lastChunk + 1) {
            targetChunk = this.chunkSource.lastChunk;
        }
        this.chunk = this.chunkSource.loadChunk(targetChunk);
        this.reseek(this.chunkSource.loadChunk(targetChunk));
        assert (this.chunk.tokens.length > 0) : "reseek should never hit empty chunk";
        assert (targetPos - this.wordPos < this.chunkSource.docNumMap.getChunkSize()) : "Incorrect calculation";
    }

    protected void reseek(Chunk toChunk) {
        this.chunk = toChunk;
        this.tokens = this.chunk.tokens;
        this.tokNum = 0;
        this.wordPos = this.chunk.tokens.length > 0 ? this.chunk.minWordPos - 1 + this.chunk.tokens[0].getPositionIncrement() : this.chunk.minWordPos;
    }

    public void seekFirst(int targetPos, boolean force) {
        if (force) {
            this.reseek(targetPos);
        }
        super.seekFirst(targetPos, force);
    }

    public void seekLast(int targetPos, boolean force) {
        if (force) {
            this.reseek(targetPos);
        }
        super.seekLast(targetPos, force);
    }

    public MarkPos createPos() {
        return new ChunkMarkPos();
    }

    public void getPos(MarkPos pos, int startOrEnd) {
        ChunkMarkPos cm = (ChunkMarkPos)pos;
        switch (startOrEnd) {
            case 0: 
            case 4: {
                cm.charPos = -1;
                cm.wordPos = -1;
                cm.chunk = null;
                break;
            }
            case 1: {
                cm.wordPos = this.wordPos;
                cm.charPos = this.tokens[this.tokNum].startOffset();
                cm.chunk = this.chunk;
                break;
            }
            case 2: {
                cm.wordPos = this.wordPos;
                cm.charPos = this.tokens[this.tokNum].startOffset() + this.tokens[this.tokNum].endOffset() - this.tokens[this.tokNum].startOffset();
                cm.chunk = this.chunk;
                break;
            }
            case 3: {
                cm.wordPos = this.wordPos;
                cm.charPos = this.tokNum == this.tokens.length - 1 ? this.tokens[this.tokNum].startOffset() + this.chunk.text.length() - this.tokens[this.tokNum].startOffset() : this.tokens[this.tokNum].startOffset() + this.tokens[this.tokNum + 1].startOffset() - this.tokens[this.tokNum].startOffset();
                cm.chunk = this.chunk;
                break;
            }
            default: {
                assert (false) : "Unknown start/end mode";
                break;
            }
        }
    }
}

