/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanChunkedNotQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;
    private int slop;
    private int chunkBump = 1;

    public SpanChunkedNotQuery(SpanQuery include, SpanQuery exclude, int slop) {
        this.include = include;
        this.exclude = exclude;
        this.slop = slop;
        if (!include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    public void setSlop(int slop, int chunkBump) {
        this.slop = slop;
        this.chunkBump = chunkBump;
    }

    public int getSlop() {
        return this.slop;
    }

    public String getField() {
        return this.include.getField();
    }

    public Collection getTerms() {
        return this.include.getTerms();
    }

    public Query[] getSubQueries() {
        Query[] result = new Query[]{this.include, this.exclude};
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenInclude = (SpanQuery)this.include.rewrite(reader);
        SpanQuery rewrittenExclude = (SpanQuery)this.exclude.rewrite(reader);
        if (rewrittenInclude == this.include && rewrittenExclude == this.exclude) {
            return this;
        }
        SpanChunkedNotQuery clone = (SpanChunkedNotQuery)this.clone();
        clone.include = rewrittenInclude;
        clone.exclude = rewrittenExclude;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanChunkedNot(");
        buffer.append(this.include.toString(field));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field));
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(final IndexReader reader, final Searcher searcher) throws IOException {
        return new Spans(){
            private Spans includeSpans;
            private boolean moreInclude;
            private Spans excludeSpans;
            private boolean moreExclude;
            private boolean firstTime;
            {
                this.includeSpans = SpanChunkedNotQuery.this.include.getSpans(reader, searcher);
                this.moreInclude = true;
                this.excludeSpans = SpanChunkedNotQuery.this.exclude.getSpans(reader, searcher);
                this.moreExclude = true;
                this.firstTime = true;
            }

            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.next();
                }
                if (this.firstTime) {
                    this.moreExclude = this.excludeSpans.next();
                    this.firstTime = false;
                }
                while (this.moreInclude && this.moreExclude) {
                    int includeDoc = this.includeSpans.doc();
                    if (this.includeSpans.start() < SpanChunkedNotQuery.this.slop) {
                        --includeDoc;
                    }
                    if (includeDoc > this.excludeSpans.doc()) {
                        this.moreExclude = this.excludeSpans.skipTo(includeDoc);
                    }
                    while (this.moreExclude && this.endPos(this.excludeSpans) + SpanChunkedNotQuery.this.slop <= this.startPos(this.includeSpans)) {
                        this.moreExclude = this.excludeSpans.next();
                    }
                    if (!this.moreExclude || this.endPos(this.includeSpans) <= this.startPos(this.excludeSpans) - SpanChunkedNotQuery.this.slop) break;
                    this.moreInclude = this.includeSpans.next();
                }
                return this.moreInclude;
            }

            private int baseDoc() {
                if (!this.moreInclude) {
                    return this.moreExclude ? this.excludeSpans.doc() : 0;
                }
                if (!this.moreExclude) {
                    return this.includeSpans.doc();
                }
                return Math.min(this.includeSpans.doc(), this.excludeSpans.doc());
            }

            private int startPos(Spans spans) {
                return (spans.doc() - this.baseDoc()) * SpanChunkedNotQuery.this.chunkBump + spans.start();
            }

            private int endPos(Spans spans) {
                return (spans.doc() - this.baseDoc()) * SpanChunkedNotQuery.this.chunkBump + spans.end();
            }

            public boolean skipTo(int target) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.skipTo(target);
                }
                if (!this.moreInclude) {
                    return false;
                }
                if (this.moreExclude && this.includeSpans.doc() > this.excludeSpans.doc()) {
                    this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                }
                while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start() - SpanChunkedNotQuery.this.slop) {
                    this.moreExclude = this.excludeSpans.next();
                }
                if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() + SpanChunkedNotQuery.this.slop <= this.excludeSpans.start()) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.includeSpans.doc();
            }

            public int start() {
                return this.includeSpans.start();
            }

            public int end() {
                return this.includeSpans.end();
            }

            public float score() {
                return this.includeSpans.score() * SpanChunkedNotQuery.this.getBoost();
            }

            public String toString() {
                return "spans(" + SpanChunkedNotQuery.this.toString() + ")";
            }

            public Explanation explain() throws IOException {
                if (SpanChunkedNotQuery.this.getBoost() == 1.0f) {
                    return this.includeSpans.explain();
                }
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanChunkedNotQuery.this.getBoost(), "boost");
                result.addDetail(boostExpl);
                Explanation inclExpl = this.includeSpans.explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }
}

