/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class SparseStringComparator
implements SortComparatorSource {
    private static final WeakHashMap cache = new WeakHashMap();
    private static final EntryComparator entryComparator = new EntryComparator();

    public ScoreDocComparator newComparator(IndexReader reader, String fieldName) throws IOException {
        SparseComp comp;
        HashMap<String, SparseComp> readerCache = (HashMap<String, SparseComp>)cache.get(reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, SparseComp>();
            cache.put(reader, readerCache);
        }
        if ((comp = (SparseComp)readerCache.get(fieldName = fieldName.intern())) == null) {
            comp = new SparseComp(reader, fieldName);
            readerCache.put(fieldName, comp);
        }
        return comp;
    }

    static class EntryComparator
    implements Comparator {
        EntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            int d1 = ((Entry)o1).docId;
            int d2 = ((Entry)o2).docId;
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    class Entry {
        int docId;
        String termText;
        int order;

        Entry() {
        }
    }

    private class SparseComp
    implements ScoreDocComparator {
        ArrayList entries = new ArrayList(500);
        boolean flipEmpty = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SparseComp(IndexReader reader, String field) throws IOException {
            if (field.endsWith(":flipEmpty")) {
                this.flipEmpty = true;
                field = field.replace(":flipEmpty", "");
            }
            field = field.intern();
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            int t = 0;
            HashMap<Integer, String> docs = new HashMap<Integer, String>();
            try {
                if (termEnum.term() == null) {
                    throw new RuntimeException("no terms in field " + field);
                }
                do {
                    Term term;
                    if ((term = termEnum.term()).field() != field) {
                        break;
                    }
                    String termText = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        int docId = termDocs.doc();
                        Integer key = new Integer(docId);
                        if (docs.get(key) != null) {
                            throw new RuntimeException("A document has more than one term ('" + termText + "', '" + (String)docs.get(key) + "') in field " + field);
                        }
                        docs.put(key, termText);
                        Entry ent = new Entry();
                        ent.docId = termDocs.doc();
                        ent.termText = termText;
                        ent.order = t;
                        this.entries.add(ent);
                    }
                    ++t;
                } while (termEnum.next());
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            Collections.sort(this.entries, entryComparator);
        }

        private Entry findEntry(int docId) {
            Entry toFind = new Entry();
            toFind.docId = docId;
            int index = Collections.binarySearch(this.entries, toFind, entryComparator);
            if (index < 0 || index >= this.entries.size()) {
                return null;
            }
            Entry got = (Entry)this.entries.get(index);
            if (got.docId != docId) {
                return null;
            }
            return got;
        }

        public int compare(ScoreDoc d1, ScoreDoc d2) {
            int o2;
            int o1;
            Entry e1 = this.findEntry(d1.doc);
            Entry e2 = this.findEntry(d2.doc);
            int n = e1 != null ? e1.order : (o1 = this.flipEmpty ? Integer.MIN_VALUE : Integer.MAX_VALUE);
            int n2 = e2 != null ? e2.order : (o2 = this.flipEmpty ? Integer.MIN_VALUE : Integer.MAX_VALUE);
            if (o1 < o2) {
                return -1;
            }
            if (o1 > o2) {
                return 1;
            }
            return 0;
        }

        public Comparable sortValue(ScoreDoc i) {
            Entry ent = this.findEntry(i.doc);
            if (ent != null) {
                return ent.termText;
            }
            return "";
        }

        public int sortType() {
            return 9;
        }
    }
}

