/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mark;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.mark.BasicMarkPos;
import org.apache.lucene.mark.MarkPos;
import org.apache.lucene.mark.WordIter;

public class BasicWordIter
implements WordIter,
Cloneable {
    protected String text;
    protected Token[] tokens;
    protected int tokNum;
    protected int wordPos = -1;
    protected int maxWordPos = -1;

    public BasicWordIter(String text, TokenStream stream) throws IOException {
        Token t;
        this.text = text;
        ArrayList<Token> tokenList = new ArrayList<Token>(10);
        while ((t = stream.next()) != null) {
            tokenList.add(t);
            this.maxWordPos += t.getPositionIncrement();
        }
        stream.close();
        this.tokens = tokenList.toArray(new Token[tokenList.size()]);
        this.wordPos = -1;
        this.tokNum = -1;
    }

    protected BasicWordIter() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next(boolean force) {
        if (this.tokNum >= this.tokens.length - 1) {
            return false;
        }
        ++this.tokNum;
        this.wordPos += this.tokens[this.tokNum].getPositionIncrement();
        return true;
    }

    public boolean prev(boolean force) {
        if (this.tokNum <= 0) {
            return false;
        }
        this.wordPos -= this.tokens[this.tokNum].getPositionIncrement();
        --this.tokNum;
        return true;
    }

    public void seekFirst(int targetPos, boolean force) {
        while (targetPos <= this.wordPos && this.prev(force && targetPos < this.wordPos)) {
        }
        while (targetPos > this.wordPos && this.next(force)) {
        }
    }

    public void seekLast(int targetPos, boolean force) {
        while (targetPos >= this.wordPos && this.next(force && targetPos > this.wordPos)) {
        }
        while (targetPos < this.wordPos && this.prev(force)) {
        }
    }

    public MarkPos getPos(int startOrEnd) {
        BasicMarkPos pos = new BasicMarkPos();
        this.getPos(pos, startOrEnd);
        return pos;
    }

    public void getPos(MarkPos pos, int startOrEnd) {
        BasicMarkPos bm = (BasicMarkPos)pos;
        bm.fullText = this.text;
        switch (startOrEnd) {
            case 0: {
                bm.wordPos = 0;
                bm.charPos = 0;
                break;
            }
            case 1: {
                bm.wordPos = this.wordPos;
                bm.charPos = this.tokens[this.tokNum].startOffset();
                break;
            }
            case 2: {
                bm.wordPos = this.wordPos;
                bm.charPos = this.tokens[this.tokNum].endOffset();
                break;
            }
            case 3: {
                bm.wordPos = this.wordPos;
                if (this.tokNum < this.tokens.length - 1) {
                    bm.charPos = this.tokens[this.tokNum + 1].startOffset();
                    break;
                }
                bm.charPos = this.text.length();
                break;
            }
            case 4: {
                bm.wordPos = this.maxWordPos;
                bm.charPos = this.text.length();
                break;
            }
            default: {
                assert (false) : "Unknown start/end mode";
                break;
            }
        }
    }

    public final String term() {
        return this.tokens[this.tokNum].termText();
    }
}

