/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.mark.BasicWordIter;
import org.apache.lucene.mark.MarkCollector;
import org.apache.lucene.mark.MarkPos;
import org.apache.lucene.mark.WordIter;
import org.apache.lucene.search.spans.FieldSpans;
import org.apache.lucene.search.spans.Span;

public class ContextMarker {
    public static final int MARK_NO_TERMS = 0;
    public static final int MARK_SPAN_TERMS = 1;
    public static final int MARK_CONTEXT_TERMS = 2;
    public static final int MARK_ALL_TERMS = 3;
    private int maxContext;
    private WordIter iter0;
    private WordIter iter1;
    private MarkCollector collector;
    private Set terms;
    private Set stopSet;
    private int termMode;
    private int termsMarkedPos = 0;
    private MarkPos tmpPos;
    private int prevEndWord = -1;

    public void markField(String field, FieldSpans fieldSpans, MarkCollector collector) {
        BasicWordIter wordIter = new BasicWordIter();
        ContextMarker.markField(fieldSpans, field, wordIter, 80, 1, null, collector);
    }

    public void markField(String field, FieldSpans fieldSpans, WordIter iter, int maxContext, int termMode, Set stopSet, MarkCollector collector) {
        ContextMarker.markField(fieldSpans, field, iter, maxContext, termMode, stopSet, collector);
    }

    public static void markField(FieldSpans fieldSpans, String field, WordIter iter, int maxContext, int termMode, Set stopSet, MarkCollector collector) {
        int i;
        if (termMode < 0 || termMode > 3) {
            throw new IllegalArgumentException("Invalid termMode");
        }
        if (fieldSpans == null) {
            collector.beginField(iter.getPos(0));
            collector.endField(iter.getPos(4));
            return;
        }
        Set terms = fieldSpans.getTerms(field);
        Span[] posOrderSpans = fieldSpans.getSpans(field);
        if (!(terms != null && !terms.isEmpty() && termMode != 0 || posOrderSpans != null && posOrderSpans.length != 0)) {
            collector.beginField(iter.getPos(0));
            collector.endField(iter.getPos(4));
            return;
        }
        float maxScore = 0.0f;
        for (i = 0; i < posOrderSpans.length; ++i) {
            maxScore = Math.max(maxScore, posOrderSpans[i].score);
        }
        for (i = 0; i < posOrderSpans.length; ++i) {
            posOrderSpans[i].score /= maxScore;
        }
        ContextMarker marker = new ContextMarker(maxContext, termMode, terms, stopSet, iter, collector);
        marker.mark(posOrderSpans, maxContext);
    }

    public ContextMarker(int maxContext, int termMode, Set terms, Set stopSet, WordIter wordIter, MarkCollector collector) {
        this.maxContext = maxContext;
        this.termMode = termMode;
        this.terms = terms;
        this.stopSet = stopSet;
        this.iter0 = wordIter;
        this.collector = collector;
    }

    public void mark(Span[] posOrderSpans, int maxContext) {
        MarkPos contextStart = null;
        MarkPos contextEnd = null;
        if (maxContext > 0 && posOrderSpans.length > 0) {
            this.iter0.seekFirst(posOrderSpans[0].start, true);
            contextStart = this.iter0.getPos(1);
            contextEnd = (MarkPos)contextStart.clone();
        }
        this.collector.beginField(this.iter0.getPos(0));
        for (int i = 0; i < posOrderSpans.length; ++i) {
            Span nextSpan;
            Span posSpan = posOrderSpans[i];
            Span span = nextSpan = i + 1 < posOrderSpans.length ? posOrderSpans[i + 1] : null;
            if (maxContext > 0) {
                this.findContext(posSpan, nextSpan, contextStart, contextEnd);
            }
            this.emitMarks(posSpan, contextStart, contextEnd);
            posSpan = nextSpan;
        }
        if (this.termMode >= 3) {
            this.markTerms(this.iter0, this.termsMarkedPos, Integer.MAX_VALUE, false);
        }
        this.collector.endField(this.iter0.getPos(4));
    }

    void findContext(Span posSpan, Span nextSpan, MarkPos contextStart, MarkPos contextEnd) {
        this.iter0.seekFirst(posSpan.start, true);
        this.iter1 = (WordIter)this.iter0.clone();
        this.iter1.seekLast(posSpan.end - 1, false);
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsEnabled && this.terms != null) {
            String endTerm;
            String startTerm = this.iter0.term();
            if (!this.terms.contains(startTerm) && startTerm.length() > 0) {
                ArrayList sortTerms = new ArrayList(this.terms.size());
                sortTerms.addAll(this.terms);
                Collections.sort(sortTerms);
                System.out.println("Terms: " + sortTerms.toString());
                assert (false) : "first term in span not in term map - perhaps wrong analyzer was used?";
            }
            if (!this.terms.contains(endTerm = this.iter1.term()) && endTerm.length() > 0) {
                ArrayList sortTerms = new ArrayList(this.terms.size());
                sortTerms.addAll(this.terms);
                Collections.sort(sortTerms);
                System.out.println("Terms: " + sortTerms.toString());
                assert (false) : "last term in span not in term map - perhaps wrong analyzer was used?";
            }
        }
        this.iter0.getPos(contextStart, 1);
        this.iter1.getPos(contextEnd, 3);
        int addedToStart = 0;
        int addedToEnd = 0;
        boolean more0 = true;
        boolean more1 = true;
        int spanChars = contextStart.countTextTo(contextEnd);
        while ((more0 || more1) && spanChars + addedToStart + addedToEnd < this.maxContext) {
            if ((!more1 || addedToStart <= addedToEnd) && more0 && (more0 = this.iter0.prev(false))) {
                if (this.tmpPos == null) {
                    this.tmpPos = this.iter0.getPos(1);
                } else {
                    this.iter0.getPos(this.tmpPos, 1);
                }
                if (this.tmpPos.wordPos() <= this.prevEndWord) {
                    more0 = false;
                } else if (this.tmpPos.countTextTo(contextEnd) > this.maxContext) {
                    more0 = false;
                } else {
                    addedToStart += this.tmpPos.countTextTo(contextStart);
                    this.iter0.getPos(contextStart, 1);
                }
            }
            if (more0 && addedToEnd > addedToStart || !more1 || !(more1 = this.iter1.next(false))) continue;
            if (this.tmpPos == null) {
                this.tmpPos = this.iter1.getPos(3);
            } else {
                this.iter1.getPos(this.tmpPos, 3);
            }
            if (nextSpan != null && this.tmpPos.wordPos() >= (posSpan.end + nextSpan.start) / 2) {
                more1 = false;
                continue;
            }
            if (contextStart.countTextTo(this.tmpPos) > this.maxContext) {
                more1 = false;
                continue;
            }
            addedToEnd += contextEnd.countTextTo(this.tmpPos);
            this.iter1.getPos(contextEnd, 3);
        }
        if (spanChars < this.maxContext) assert (spanChars + addedToStart + addedToEnd <= this.maxContext);
        this.prevEndWord = contextEnd.wordPos();
    }

    void emitMarks(Span posSpan, MarkPos contextStart, MarkPos contextEnd) {
        if (this.maxContext > 0) {
            if (this.termMode >= 3) {
                this.markTerms(this.iter0, this.termsMarkedPos, contextStart.wordPos(), false);
            }
            this.collector.beginContext((MarkPos)contextStart.clone(), posSpan);
        }
        if (this.termMode >= 2) {
            this.markTerms(this.iter0, contextStart.wordPos(), posSpan.start, false);
        }
        this.iter0.seekFirst(posSpan.start, true);
        this.collector.beginSpan(this.iter0.getPos(1), posSpan);
        if (this.termMode >= 1) {
            this.markTerms(this.iter0, posSpan.start, posSpan.end, true);
        }
        this.iter0.seekLast(posSpan.end - 1, false);
        this.collector.endSpan(this.iter0.getPos(2));
        if (this.maxContext > 0) {
            if (this.termMode >= 2) {
                this.markTerms(this.iter0, posSpan.end, contextEnd.wordPos() + 1, false);
            }
            this.collector.endContext((MarkPos)contextEnd.clone());
        }
    }

    private void markTerms(WordIter iter, int fromPos, int toPos, boolean markStopWords) {
        if (this.terms == null) {
            return;
        }
        if (fromPos == toPos) {
            return;
        }
        iter.seekFirst(fromPos, true);
        do {
            if (this.tmpPos == null) {
                this.tmpPos = iter.getPos(1);
            } else {
                iter.getPos(this.tmpPos, 1);
            }
            if (this.tmpPos.wordPos() < fromPos || this.tmpPos.wordPos() >= toPos) break;
            String term = iter.term();
            if (!this.terms.contains(term) || !markStopWords && this.stopSet != null && this.stopSet.contains(term)) continue;
            this.collector.term((MarkPos)this.tmpPos.clone(), iter.getPos(2), term);
        } while (iter.next(true));
        if (toPos < Integer.MAX_VALUE) {
            iter.seekLast(toPos - 1, true);
        }
        this.termsMarkedPos = toPos;
    }
}

