/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.search.spans.FieldSpans;
import org.apache.lucene.search.spans.Span;
import org.apache.lucene.search.spans.SpanPosComparator;
import org.apache.lucene.search.spans.SpanRecordingScorer;

public class FieldSpanSource {
    String[] fields;
    SpanRecordingScorer[][] scorersPerField;
    ScoreOrder[] scoreOrder = new ScoreOrder[0];
    int curDoc = -1;
    private static ScoreComparator theScoreComparator = new ScoreComparator();

    FieldSpanSource(SpanRecordingScorer[] scorers) {
        int i;
        HashMap<String, ArrayList<SpanRecordingScorer>> map = new HashMap<String, ArrayList<SpanRecordingScorer>>();
        for (i = 0; i < scorers.length; ++i) {
            String field = scorers[i].getField();
            ArrayList<SpanRecordingScorer> list = (ArrayList<SpanRecordingScorer>)map.get(field);
            if (list == null) {
                list = new ArrayList<SpanRecordingScorer>();
                map.put(field, list);
            }
            list.add(scorers[i]);
        }
        this.fields = map.keySet().toArray(new String[map.size()]);
        this.scorersPerField = new SpanRecordingScorer[this.fields.length][];
        for (i = 0; i < this.fields.length; ++i) {
            ArrayList list = (ArrayList)map.get(this.fields[i]);
            this.scorersPerField[i] = list.toArray(new SpanRecordingScorer[list.size()]);
        }
    }

    public synchronized FieldSpans getSpans(int doc) {
        if (doc != this.curDoc) {
            throw new UnsupportedOperationException("FieldSpanSource can only retrieve spans for current document");
        }
        FieldSpans ret = new FieldSpans();
        for (int i = 0; i < this.fields.length; ++i) {
            this.addSpans(doc, this.fields[i], this.scorersPerField[i], ret);
        }
        return ret;
    }

    private void addSpans(int doc, String field, SpanRecordingScorer[] scorers, FieldSpans out) {
        ScoreOrder o;
        int nToDedupe = 0;
        int maxSpans = 0;
        HashSet terms = null;
        for (int i = 0; i < scorers.length; ++i) {
            if (scorers[i].getSpanDoc() != doc) continue;
            nToDedupe += scorers[i].getSpanCount();
            maxSpans = Math.max(maxSpans, scorers[i].getMaxSpans());
            if (terms == null) {
                terms = scorers[i].getTerms();
                continue;
            }
            HashSet newTerms = new HashSet();
            newTerms.addAll(terms);
            newTerms.addAll(scorers[i].getTerms());
            terms = newTerms;
        }
        if (nToDedupe == 0) {
            return;
        }
        Span[] toDedupe = new Span[nToDedupe];
        int start = 0;
        for (int i = 0; i < scorers.length; ++i) {
            if (scorers[i].getSpanDoc() != doc) continue;
            int count = scorers[i].getSpanCount();
            System.arraycopy(scorers[i].getSpans(), 0, toDedupe, start, count);
            start += count;
        }
        assert (start == nToDedupe) : "internal error: mis-counted spans";
        Arrays.sort(toDedupe, SpanPosComparator.theInstance);
        int longestSpan = 0;
        for (int i = 0; i < nToDedupe; ++i) {
            longestSpan = Math.max(longestSpan, toDedupe[i].end - toDedupe[i].start);
        }
        if (this.scoreOrder.length < nToDedupe) {
            ScoreOrder[] newScoreOrder = new ScoreOrder[nToDedupe + 5];
            System.arraycopy(this.scoreOrder, 0, newScoreOrder, 0, this.scoreOrder.length);
            for (int i = this.scoreOrder.length; i < newScoreOrder.length; ++i) {
                newScoreOrder[i] = new ScoreOrder();
            }
            this.scoreOrder = newScoreOrder;
        }
        for (int i = 0; i < nToDedupe; ++i) {
            this.scoreOrder[i].span = toDedupe[i];
            this.scoreOrder[i].posOrder = i;
            this.scoreOrder[i].cancelled = false;
            this.scoreOrder[i].prevInPosOrder = i - 1 >= 0 ? this.scoreOrder[i - 1] : null;
            this.scoreOrder[i].nextInPosOrder = i + 1 < nToDedupe ? this.scoreOrder[i + 1] : null;
            this.scoreOrder[i].nextDeduped = null;
        }
        Arrays.sort(this.scoreOrder, 0, nToDedupe, theScoreComparator);
        int nDeduped = 0;
        int totalDeduped = 0;
        ScoreOrder firstDeduped = null;
        ScoreOrder lastDeduped = null;
        for (int i = 0; i < nToDedupe; ++i) {
            if (this.scoreOrder[i].cancelled) continue;
            ++totalDeduped;
            if (nDeduped < maxSpans) {
                if (firstDeduped == null) {
                    firstDeduped = this.scoreOrder[i];
                } else {
                    lastDeduped.nextDeduped = this.scoreOrder[i];
                }
                lastDeduped = this.scoreOrder[i];
                ++nDeduped;
            }
            Span scoreSpan = this.scoreOrder[i].span;
            o = this.scoreOrder[i].prevInPosOrder;
            while (o != null && o.span.start + longestSpan > scoreSpan.start) {
                assert (o.span.start <= scoreSpan.start);
                if (o.span.end > scoreSpan.start) {
                    o.cancelled = true;
                }
                assert (o.posOrder == 0 || o.prevInPosOrder.posOrder == o.posOrder - 1);
                o = o.prevInPosOrder;
            }
            o = this.scoreOrder[i].nextInPosOrder;
            while (o != null && o.span.start < scoreSpan.end) {
                o.cancelled = true;
                assert (o.posOrder == nToDedupe - 1 || o.nextInPosOrder.posOrder == o.posOrder + 1);
                o = o.nextInPosOrder;
            }
        }
        Span[] outSpans = new Span[nDeduped];
        int rank = 0;
        float prevScore = Float.MAX_VALUE;
        int i = 0;
        o = firstDeduped;
        while (o != null) {
            assert (!o.cancelled) : "kept span was cancelled";
            Span s = (Span)o.span.clone();
            assert (s.score <= prevScore) : "incorrect dedupe list linking";
            if (rank == nDeduped - 1) assert (o == lastDeduped);
            prevScore = s.score;
            s.rank = rank++;
            outSpans[i++] = s;
            o = o.nextDeduped;
        }
        assert (rank == nDeduped) : "incorrect dedupe list linking";
        Arrays.sort(outSpans, SpanPosComparator.theInstance);
        out.recordSpans(field, totalDeduped, outSpans, terms);
    }

    private static class ScoreComparator
    implements Comparator {
        private ScoreComparator() {
        }

        public int compare(Object o1, Object o2) {
            Span s1 = ((ScoreOrder)o1).span;
            Span s2 = ((ScoreOrder)o2).span;
            if (s1.score < s2.score) {
                return 1;
            }
            if (s1.score > s2.score) {
                return -1;
            }
            if (s1.start == s2.start) {
                return s2.end - s1.end;
            }
            return s1.start - s2.start;
        }
    }

    private class ScoreOrder {
        Span span;
        int posOrder;
        boolean cancelled;
        ScoreOrder nextInPosOrder;
        ScoreOrder prevInPosOrder;
        ScoreOrder nextDeduped;

        private ScoreOrder() {
        }
    }
}

