/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SpanDechunkingQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanRangeQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;

public abstract class QueryTraverser {
    public void traverseQuery(Query q) {
        if (q instanceof BooleanQuery) {
            this.traverse((BooleanQuery)q);
        } else if (q instanceof SpanNearQuery) {
            this.traverse((SpanNearQuery)q);
        } else if (q instanceof SpanOrNearQuery) {
            this.traverse((SpanOrNearQuery)q);
        } else if (q instanceof SpanOrQuery) {
            this.traverse((SpanOrQuery)q);
        } else if (q instanceof SpanChunkedNotQuery) {
            this.traverse((SpanChunkedNotQuery)q);
        } else if (q instanceof SpanNotQuery) {
            this.traverse((SpanNotQuery)q);
        } else if (q instanceof SpanNotNearQuery) {
            this.traverse((SpanNotNearQuery)q);
        } else if (q instanceof SpanDechunkingQuery) {
            this.traverse((SpanDechunkingQuery)q);
        } else if (q instanceof TermQuery) {
            this.traverse((TermQuery)q);
        } else if (q instanceof SpanWildcardQuery) {
            this.traverse((SpanWildcardQuery)q);
        } else if (q instanceof SpanTermQuery) {
            this.traverse((SpanTermQuery)q);
        } else if (q instanceof SpanRangeQuery) {
            this.traverse((SpanRangeQuery)q);
        } else assert (false) : "unsupported query type for traversal";
    }

    protected void traverse(BooleanQuery bq) {
        BooleanClause[] clauses = bq.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            this.traverseQuery(clauses[i].getQuery());
        }
    }

    protected void traverse(SpanNearQuery nq) {
        SpanQuery[] clauses = nq.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            this.traverseQuery(clauses[i]);
        }
    }

    protected void traverse(SpanOrNearQuery nq) {
        SpanQuery[] clauses = nq.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            this.traverseQuery(clauses[i]);
        }
    }

    protected void traverse(SpanOrQuery oq) {
        SpanQuery[] clauses = oq.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            this.traverseQuery(clauses[i]);
        }
    }

    protected void traverse(SpanChunkedNotQuery nq) {
        this.traverseQuery(nq.getInclude());
        this.traverseQuery(nq.getExclude());
    }

    protected void traverse(SpanNotQuery nq) {
        this.traverseQuery(nq.getInclude());
        this.traverseQuery(nq.getExclude());
    }

    protected void traverse(SpanNotNearQuery nq) {
        this.traverseQuery(nq.getInclude());
        this.traverseQuery(nq.getExclude());
    }

    protected void traverse(SpanDechunkingQuery nq) {
        this.traverseQuery(nq.getWrapped());
    }

    protected void traverse(TermQuery q) {
    }

    protected void traverse(SpanTermQuery q) {
    }

    protected void traverse(SpanWildcardQuery q) {
    }

    protected void traverse(SpanRangeQuery q) {
    }
}

