/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldSpanSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SpanHitCollector;
import org.apache.lucene.search.spans.SpanRecordingScorer;

public class RecordingSearcher
extends IndexSearcher {
    private IndexReader reader;
    private Vector registered;

    public RecordingSearcher(IndexReader r) {
        super(r);
        this.reader = r;
    }

    public void search(Query query, SpanHitCollector results) throws IOException {
        this.search(query, null, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Query query, Filter filter, final SpanHitCollector results) throws IOException {
        SpanRecordingScorer[] recordingScorers;
        Scorer scorer;
        SpanHitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new SpanHitCollector(){
                private final SpanHitCollector mresults;
                {
                    this.mresults = results;
                }

                public final void collect(int doc, float score, FieldSpanSource src) {
                    if (bits.get(doc)) {
                        this.mresults.collect(doc, score, src);
                    }
                }
            };
        }
        RecordingSearcher recordingSearcher = this;
        synchronized (recordingSearcher) {
            this.registered = new Vector();
            scorer = query.weight(this).scorer(this.reader);
            recordingScorers = this.registered.toArray(new SpanRecordingScorer[this.registered.size()]);
            this.registered = null;
        }
        if (scorer == null) {
            return;
        }
        FieldSpanSource spanSource = new FieldSpanSource(recordingScorers);
        while (scorer.next()) {
            int doc;
            spanSource.curDoc = doc = scorer.doc();
            float score = scorer.score();
            collector.collect(doc, score, spanSource);
        }
    }

    public void registerRecordingScorer(SpanRecordingScorer scorer) {
        if (this.registered != null) {
            this.registered.add(scorer);
        }
    }
}

