/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.search.spans.Span;

public class FieldSpans {
    private HashMap entries = new HashMap();

    public void recordSpans(String field, int spanTotal, Span[] spans, Set terms) {
        this.entries.put(field, new Entry(spanTotal, spans, terms));
    }

    public void addSpans(FieldSpans other) {
        this.entries.putAll(other.entries);
    }

    public Set getFields() {
        return this.entries.keySet();
    }

    public int getSpanTotal(String field) {
        Entry ent = (Entry)this.entries.get(field);
        return ent == null ? 0 : ent.total;
    }

    public int getSpanCount(String field) {
        Entry ent = (Entry)this.entries.get(field);
        return ent == null ? 0 : ent.spans.length;
    }

    public Span[] getSpans(String field) {
        Entry ent = (Entry)this.entries.get(field);
        return ent == null ? null : ent.spans;
    }

    public Set getTerms(String field) {
        Entry ent = (Entry)this.entries.get(field);
        return ent == null ? null : ent.terms;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private class Entry {
        int total;
        Span[] spans;
        Set terms;

        Entry(int total, Span[] spans, Set terms) {
            this.total = total;
            this.spans = spans;
            this.terms = terms;
        }
    }
}

