/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

class OrNearSpans
implements Spans {
    private SpanOrNearQuery query;
    private Similarity similarity;
    private int nClauses;
    private ArrayList cells;
    private int slop;
    private boolean penalizeOutOfOrder;
    private boolean more = true;
    private boolean firstTime = true;
    private int matchDist;
    private float matchTotalScore;
    private int matchEndCell;
    private int matchNumCells;
    private static final Comparator cellComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((SpansCell)o1).compareTo((SpansCell)o2);
        }
    };

    public OrNearSpans(SpanOrNearQuery query, IndexReader reader, Searcher searcher) throws IOException {
        this.query = query;
        this.slop = query.getSlop();
        this.penalizeOutOfOrder = query.penalizeOutOfOrder();
        SpanQuery[] clauses = query.getClauses();
        this.nClauses = clauses.length;
        this.cells = new ArrayList(this.nClauses);
        for (int i = 0; i < this.nClauses; ++i) {
            this.cells.add(new SpansCell(clauses[i].getSpans(reader, searcher), i));
        }
        this.similarity = searcher.getSimilarity();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.more = this.initCells(-1);
            this.firstTime = false;
        } else if (this.more && !this.nextCell()) {
            this.more = this.advance(-1);
        }
        return this.more;
    }

    private boolean initCells(int skipTo) throws IOException {
        for (int i = 0; i < this.cells.size(); ++i) {
            boolean cellMore;
            SpansCell cell = (SpansCell)this.cells.get(i);
            boolean bl = cellMore = skipTo >= 0 ? cell.skipTo(skipTo) : cell.next();
            if (cellMore) continue;
            this.cells.remove(i);
            --i;
        }
        Collections.sort(this.cells, cellComparator);
        if (this.cells.isEmpty()) {
            return false;
        }
        this.matchEndCell = 0;
        this.matchNumCells = 0;
        this.matchTotalScore = ((SpansCell)this.cells.get(0)).score();
        this.matchDist = 0;
        return true;
    }

    private boolean advance(int skipTo) throws IOException {
        boolean cellMore;
        SpansCell cell = (SpansCell)this.cells.get(0);
        boolean bl = cellMore = skipTo >= 0 ? cell.skipTo(skipTo) : cell.next();
        if (cellMore) {
            SpansCell next;
            int i;
            for (i = 0; i < this.cells.size() - 1 && cell.compareTo(next = (SpansCell)this.cells.get(i + 1)) >= 0; ++i) {
                this.cells.set(i, next);
            }
            this.cells.set(i, cell);
        } else {
            this.cells.remove(0);
            if (this.cells.isEmpty()) {
                return false;
            }
        }
        this.matchEndCell = 0;
        this.matchNumCells = 0;
        this.matchTotalScore = ((SpansCell)this.cells.get(0)).score();
        this.matchDist = 0;
        return true;
    }

    private boolean nextCell() {
        SpansCell curCell;
        SpansCell prevCell = (SpansCell)this.cells.get(this.matchEndCell);
        while (true) {
            if (this.matchEndCell + 1 == this.cells.size()) {
                return false;
            }
            curCell = (SpansCell)this.cells.get(this.matchEndCell + 1);
            if (curCell.doc() != prevCell.doc()) {
                return false;
            }
            if (curCell.start() >= prevCell.end()) break;
            ++this.matchEndCell;
        }
        assert (curCell.compareTo(prevCell) >= 0);
        int curDist = this.penalizeOutOfOrder && curCell.index < prevCell.index + 1 ? curCell.end() - prevCell.start() : curCell.start() - prevCell.end();
        if (curDist < 0) {
            curDist = -curDist;
        }
        this.matchDist += curDist;
        if (this.matchDist > this.slop) {
            return false;
        }
        this.matchTotalScore += curCell.score();
        ++this.matchEndCell;
        ++this.matchNumCells;
        return true;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.more = this.initCells(target);
            this.firstTime = false;
        } else if (this.more) {
            while (this.more && ((SpansCell)this.cells.get(0)).doc() < target) {
                this.more = this.advance(target);
            }
        }
        return this.more;
    }

    public int doc() {
        return ((SpansCell)this.cells.get(0)).doc();
    }

    public int start() {
        return ((SpansCell)this.cells.get(0)).start();
    }

    public int end() {
        return ((SpansCell)this.cells.get(this.matchEndCell)).end();
    }

    public float score() {
        float coordFactor = (float)(this.matchNumCells + 1) / (float)(this.nClauses + 1);
        float distFactor = this.similarity.sloppyFreq(this.matchDist) / (float)(this.nClauses + 1);
        return this.matchTotalScore * (coordFactor + distFactor) * this.query.getBoost();
    }

    public String toString() {
        return "spans(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    public Explanation explain() throws IOException {
        Explanation totalExpl;
        Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
        if (this.matchEndCell == 0) {
            totalExpl = ((SpansCell)this.cells.get((int)0)).spans.explain();
        } else {
            float totalScore = 0.0f;
            totalExpl = new Explanation(0.0f, "totalMatchScore, sum of:");
            SpansCell prevCell = null;
            for (int i = 0; i <= this.matchEndCell; ++i) {
                SpansCell cell = (SpansCell)this.cells.get(i);
                if (prevCell != null && cell.start() < prevCell.end()) continue;
                totalScore += cell.score();
                totalExpl.addDetail(cell.spans.explain());
                prevCell = cell;
            }
            totalExpl.setValue(totalScore);
        }
        result.addDetail(totalExpl);
        Explanation boostExpl = new Explanation(this.query.getBoost(), "boost");
        if (boostExpl.getValue() != 1.0f) {
            result.addDetail(boostExpl);
        }
        Explanation distExpl = new Explanation(0.0f, "distFactor(sloppyFreq/" + (this.nClauses + 1) + ")");
        Explanation slopExpl = new Explanation(this.similarity.sloppyFreq(this.matchDist), "sloppyFreq(slop=" + this.matchDist + ")");
        distExpl.addDetail(slopExpl);
        distExpl.setValue(slopExpl.getValue() / (float)(this.nClauses + 1));
        Explanation coordExpl = new Explanation((float)(this.matchNumCells + 1) / (float)(this.nClauses + 1), "coordFactor(" + (this.matchNumCells + 1) + "/" + (this.nClauses + 1) + ")");
        Explanation combinedFactorsExpl = new Explanation(distExpl.getValue() + coordExpl.getValue(), "combinedFactors = sum of");
        combinedFactorsExpl.addDetail(distExpl);
        combinedFactorsExpl.addDetail(coordExpl);
        result.addDetail(combinedFactorsExpl);
        result.setValue(totalExpl.getValue() * boostExpl.getValue() * combinedFactorsExpl.getValue());
        return result;
    }

    private class SpansCell {
        Spans spans;
        int index;

        SpansCell(Spans spans, int index) {
            this.spans = spans;
            this.index = index;
        }

        final int doc() {
            return this.spans.doc();
        }

        final int start() {
            return this.spans.start();
        }

        final int end() {
            return this.spans.end();
        }

        final float score() {
            return this.spans.score();
        }

        final boolean next() throws IOException {
            return this.spans.next();
        }

        final boolean skipTo(int doc) throws IOException {
            return this.spans.skipTo(doc);
        }

        int compareTo(SpansCell other) {
            if (this.doc() == other.doc()) {
                if (this.start() == other.start()) {
                    if (this.end() == other.end()) {
                        return this.index - other.index;
                    }
                    return this.end() - other.end();
                }
                return this.start() - other.start();
            }
            return this.doc() - other.doc();
        }
    }
}

