/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanFirstQuery
extends SpanQuery {
    private SpanQuery match;
    private int end;

    public SpanFirstQuery(SpanQuery match, int end) {
        this.match = match;
        this.end = end;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    public String getField() {
        return this.match.getField();
    }

    public Collection getTerms() {
        return this.match.getTerms();
    }

    public Query[] getSubQueries() {
        Query[] result = new Query[]{this.match};
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenMatch = (SpanQuery)this.match.rewrite(reader);
        if (rewrittenMatch == this.match) {
            return this;
        }
        SpanFirstQuery clone = (SpanFirstQuery)this.clone();
        clone.match = rewrittenMatch;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(final IndexReader reader, final Searcher searcher) throws IOException {
        return new Spans(){
            private Spans spans;
            {
                this.spans = SpanFirstQuery.this.match.getSpans(reader, searcher);
            }

            public boolean next() throws IOException {
                while (this.spans.next()) {
                    if (this.end() > SpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.spans.skipTo(target)) {
                    return false;
                }
                if (this.spans.end() <= SpanFirstQuery.this.end) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.spans.doc();
            }

            public int start() {
                return this.spans.start();
            }

            public int end() {
                return this.spans.end();
            }

            public float score() {
                return this.spans.score() * SpanFirstQuery.this.getBoost();
            }

            public String toString() {
                return "spans(" + SpanFirstQuery.this.toString() + ")";
            }

            public Explanation explain() throws IOException {
                if (SpanFirstQuery.this.getBoost() == 1.0f) {
                    return this.spans.explain();
                }
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanFirstQuery.this.getBoost(), "boost");
                result.addDetail(boostExpl);
                Explanation inclExpl = this.spans.explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }
}

