/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanNotNearQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;
    private int slop;

    public SpanNotNearQuery(SpanQuery include, SpanQuery exclude, int slop) {
        this.include = include;
        this.exclude = exclude;
        this.slop = slop;
        if (!include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    public int getSlop() {
        return this.slop;
    }

    public String getField() {
        return this.include.getField();
    }

    public Collection getTerms() {
        return this.include.getTerms();
    }

    public Query[] getSubQueries() {
        Query[] result = new Query[]{this.include, this.exclude};
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenInclude = (SpanQuery)this.include.rewrite(reader);
        SpanQuery rewrittenExclude = (SpanQuery)this.exclude.rewrite(reader);
        if (rewrittenInclude == this.include && rewrittenExclude == this.exclude) {
            return this;
        }
        SpanNotNearQuery clone = (SpanNotNearQuery)this.clone();
        clone.include = rewrittenInclude;
        clone.exclude = rewrittenExclude;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNotNear(");
        buffer.append(this.include.toString(field));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field));
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(final IndexReader reader, final Searcher searcher) throws IOException {
        return new Spans(){
            private Spans includeSpans;
            private boolean moreInclude;
            private Spans excludeSpans;
            private boolean moreExclude;
            {
                this.includeSpans = SpanNotNearQuery.this.include.getSpans(reader, searcher);
                this.moreInclude = true;
                this.excludeSpans = SpanNotNearQuery.this.exclude.getSpans(reader, searcher);
                this.moreExclude = this.excludeSpans.next();
            }

            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.next();
                }
                return this.advance();
            }

            private boolean advance() throws IOException {
                while (this.moreInclude && this.moreExclude) {
                    if (this.includeSpans.doc() > this.excludeSpans.doc()) {
                        this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                    }
                    while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start() - SpanNotNearQuery.this.slop) {
                        this.moreExclude = this.excludeSpans.next();
                    }
                    if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.excludeSpans.start() >= this.includeSpans.end() + SpanNotNearQuery.this.slop) break;
                    this.moreInclude = this.includeSpans.next();
                }
                return this.moreInclude;
            }

            public boolean skipTo(int target) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.skipTo(target);
                }
                return this.advance();
            }

            public int doc() {
                return this.includeSpans.doc();
            }

            public int start() {
                return this.includeSpans.start();
            }

            public int end() {
                return this.includeSpans.end();
            }

            public float score() {
                return this.includeSpans.score() * SpanNotNearQuery.this.getBoost();
            }

            public String toString() {
                return "spans(" + SpanNotNearQuery.this.toString() + ")";
            }

            public Explanation explain() throws IOException {
                if (SpanNotNearQuery.this.getBoost() == 1.0f) {
                    return this.includeSpans.explain();
                }
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanNotNearQuery.this.getBoost(), "boost");
                result.addDetail(boostExpl);
                Explanation inclExpl = this.includeSpans.explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }
}

