/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.limit.TermLimitException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanRangeQuery
extends SpanQuery {
    private int termLimit;
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;
    private static final int TERMS_TO_REPORT = 50;

    public SpanRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        this(lowerTerm, upperTerm, inclusive, Integer.MAX_VALUE);
    }

    public SpanRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive, int termLimit) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field(), "");
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
        this.termLimit = termLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Query rewrite(IndexReader reader) throws IOException {
        Vector<SpanTermQuery> clauses = new Vector<SpanTermQuery>();
        TermEnum enumerator = reader.terms(this.lowerTerm);
        int nTerms = 0;
        StringBuffer termReport = new StringBuffer(100);
        try {
            Term term;
            boolean checkLower = false;
            if (!this.inclusive) {
                checkLower = true;
            }
            String testField = this.getField();
            while ((term = enumerator.term()) != null && term.field() == testField) {
                if (!checkLower || term.text().compareTo(this.lowerTerm.text()) > 0) {
                    int compare;
                    checkLower = false;
                    if (this.upperTerm != null && ((compare = this.upperTerm.text().compareTo(term.text())) < 0 || !this.inclusive && compare == 0)) break;
                    if (!this.shouldSkipTerm(term)) {
                        if (nTerms < 50) {
                            termReport.append(term.text());
                            termReport.append(" ");
                        }
                        if (++nTerms == this.termLimit) {
                            throw new TermLimitException("Range query on '" + this.lowerTerm.field() + "' matched too many terms (more than " + this.termLimit + "). " + "First " + 50 + " matches: " + termReport.toString());
                        }
                        SpanTermQuery tq = new SpanTermQuery(term);
                        tq.setBoost(this.getBoost());
                        clauses.add(tq);
                    }
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            enumerator.close();
        }
        SpanQuery[] clauseArray = new SpanQuery[clauses.size()];
        clauses.toArray(clauseArray);
        SpanOrQuery orQuery = new SpanOrQuery(clauseArray);
        orQuery.setSpanRecording(this.getSpanRecording());
        return orQuery;
    }

    protected boolean shouldSkipTerm(Term t) {
        return false;
    }

    public Query combine(Query[] queries) {
        return Query.mergeBooleanQueries(queries);
    }

    public String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public Term getLowerTerm() {
        return this.lowerTerm;
    }

    public Term getUpperTerm() {
        return this.upperTerm;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public int getTermLimit() {
        return this.termLimit;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Collection getTerms() {
        throw new UnsupportedOperationException();
    }
}

