/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.RecordingSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.Span;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public class SpanRecordingScorer
extends SpanScorer {
    private String field;
    private int maxSpans;
    int nSpans;
    int scoredDoc;
    int totalDeduped;
    Span[] posOrder = new Span[0];
    Span[] toDedupe = new Span[0];
    int nToDedupe;
    Set terms;

    SpanRecordingScorer(Spans spans, SpanWeight weight, Similarity similarity, int maxSpans) throws IOException {
        super(spans, weight, similarity);
        this.spans = spans;
        this.maxSpans = maxSpans;
        this.value = weight.getValue();
        this.field = ((SpanQuery)weight.getQuery()).getField();
        Searcher searcher = weight.getSearcher();
        if (searcher instanceof RecordingSearcher) {
            ((RecordingSearcher)searcher).registerRecordingScorer(this);
        }
        Collection termColl = ((SpanQuery)weight.getQuery()).getTerms();
        this.terms = new HashSet(termColl.size() * 2);
        Iterator iter = termColl.iterator();
        while (iter.hasNext()) {
            String term = ((Term)iter.next()).text();
            this.terms.add(term);
            int sepPos = term.indexOf(126);
            if (sepPos <= 0) continue;
            this.terms.add(term.substring(0, sepPos));
            this.terms.add(term.substring(sepPos + 1));
        }
    }

    protected boolean advance() throws IOException {
        if (!this.more) {
            return false;
        }
        this.freq = 0.0f;
        this.doc = this.spans.doc();
        this.nSpans = 0;
        while (this.more && this.doc == this.spans.doc()) {
            float score = this.spans.score();
            this.freq += score;
            if (this.nSpans == this.posOrder.length) {
                this.expand();
            }
            Span span = this.posOrder[this.nSpans++];
            span.start = this.spans.start();
            span.end = this.spans.end();
            span.score = score;
            assert (span.start < span.end) : "Invalid span!";
            this.more = this.spans.next();
        }
        return this.more || this.freq != 0.0f;
    }

    private void expand() {
        int top = Math.max(10, this.posOrder.length * 3 / 2);
        Span[] newSpans = new Span[top];
        if (this.posOrder != null) {
            System.arraycopy(this.posOrder, 0, newSpans, 0, this.nSpans);
        }
        this.posOrder = newSpans;
        Span[] newSpans2 = new Span[top];
        if (this.toDedupe != null) {
            System.arraycopy(this.toDedupe, 0, newSpans2, 0, this.nSpans);
        }
        this.toDedupe = newSpans2;
        for (int i = this.nSpans; i < top; ++i) {
            this.posOrder[i] = new Span();
            this.toDedupe[i] = new Span();
        }
    }

    public int getSpanDoc() {
        return this.scoredDoc;
    }

    public String getField() {
        return this.field;
    }

    public int getSpanCount() {
        return this.nToDedupe;
    }

    public Span[] getSpans() {
        return this.toDedupe;
    }

    public int getMaxSpans() {
        return this.maxSpans;
    }

    public Set getTerms() {
        return this.terms;
    }

    public float score() throws IOException {
        if (this.scoredDoc != this.doc) {
            this.scoredDoc = this.doc;
            Span[] tmp = this.posOrder;
            this.posOrder = this.toDedupe;
            this.toDedupe = tmp;
            this.nToDedupe = this.nSpans;
        }
        return super.score();
    }
}

