/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanTermQuery
extends SpanQuery {
    private Term term;
    private int termLength;

    public SpanTermQuery(Term term) {
        this.term = term;
        this.termLength = 1;
    }

    public SpanTermQuery(Term term, int termLength) {
        this.term = term;
        this.termLength = termLength;
    }

    public Term getTerm() {
        return this.term;
    }

    public int getTermLength() {
        return this.termLength;
    }

    public String getField() {
        return this.term.field();
    }

    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public Spans getSpans(final IndexReader reader, final Searcher searcher) throws IOException {
        final float idf = this.getSimilarity(searcher).idf(this.term, searcher);
        final float value = idf * this.getBoost();
        final byte[] fieldNorms = reader.norms(this.term.field());
        return new Spans(){
            private TermPositions positions;
            private int doc;
            private int freq;
            private int count;
            private int position;
            {
                this.positions = reader.termPositions(SpanTermQuery.this.term);
                this.doc = -1;
            }

            public boolean next() throws IOException {
                if (this.count == this.freq) {
                    if (!this.positions.next()) {
                        this.doc = Integer.MAX_VALUE;
                        return false;
                    }
                    this.doc = this.positions.doc();
                    this.freq = this.positions.freq();
                    this.count = 0;
                }
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.positions.skipTo(target)) {
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
                this.doc = this.positions.doc();
                this.freq = this.positions.freq();
                this.count = 0;
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public int doc() {
                return this.doc;
            }

            public int start() {
                return this.position;
            }

            public int end() {
                return this.position + SpanTermQuery.this.termLength;
            }

            public float score() {
                return value * Similarity.decodeNorm(fieldNorms[this.doc]);
            }

            public String toString() {
                return "spans(" + SpanTermQuery.this.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + ":" + this.position));
            }

            public Explanation explain() throws IOException {
                Explanation result = new Explanation();
                result.setDescription("weight(" + this.toString() + "), product of:");
                Explanation idfExpl = new Explanation(idf, "idf(docFreq=" + searcher.docFreq(SpanTermQuery.this.term) + ")");
                result.addDetail(idfExpl);
                Explanation boostExpl = new Explanation(SpanTermQuery.this.getBoost(), "boost");
                if (SpanTermQuery.this.getBoost() != 1.0f) {
                    result.addDetail(boostExpl);
                }
                Explanation fieldNormExpl = new Explanation();
                float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[this.doc]) : 0.0f;
                fieldNormExpl.setValue(fieldNorm);
                fieldNormExpl.setDescription("fieldNorm(field=" + SpanTermQuery.this.getField() + ", doc=" + this.doc + ")");
                result.addDetail(fieldNormExpl);
                result.setValue(boostExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
                return result;
            }
        };
    }
}

