/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanRecordingScorer;
import org.apache.lucene.search.spans.SpanScorer;

class SpanWeight
implements Weight {
    private Searcher searcher;
    private float value;
    private float queryNorm;
    private float queryWeight;
    private SpanQuery query;

    public SpanWeight(SpanQuery query, Searcher searcher) {
        this.searcher = searcher;
        this.query = query;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public Query getQuery() {
        return this.query;
    }

    public float getValue() {
        return this.value;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.queryWeight = this.query.getBoost();
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float queryNorm) {
        this.queryNorm = queryNorm;
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight;
    }

    public Scorer scorer(IndexReader reader) throws IOException {
        if (this.query.getSpanRecording() == 0) {
            return new SpanScorer(this.query.getSpans(reader, this.searcher), this, this.query.getSimilarity(this.searcher));
        }
        return new SpanRecordingScorer(this.query.getSpans(reader, this.searcher), this, this.query.getSimilarity(this.searcher), this.query.getSpanRecording());
    }

    public Explanation explain(IndexReader reader, int doc) throws IOException {
        Explanation result = new Explanation();
        result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
        Explanation queryExpl = new Explanation();
        queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
        Explanation boostExpl = new Explanation(this.getQuery().getBoost(), "boost");
        if (this.getQuery().getBoost() != 1.0f) {
            queryExpl.addDetail(boostExpl);
        }
        Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
        queryExpl.addDetail(queryNormExpl);
        queryExpl.setValue(boostExpl.getValue() * queryNormExpl.getValue());
        result.addDetail(queryExpl);
        Explanation tfExpl = this.scorer(reader).explain(doc);
        result.addDetail(tfExpl);
        result.setValue(queryExpl.getValue() * tfExpl.getValue());
        if (queryExpl.getValue() == 1.0f) {
            return tfExpl;
        }
        return result;
    }
}

