/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.util.StringUtil;
import org.cdlib.xtf.textEngine.DefaultQueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryRequestParser;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.textIndexer.tokenizer.ParseException;
import org.cdlib.xtf.textIndexer.tokenizer.XTFTokenizer;
import org.cdlib.xtf.util.Path;

public class SpellKeywordTest {
    private String indexDir;

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            new SpellKeywordTest().test(args[0]);
        } else {
            System.err.println("Usage: test <wordFile>\n");
            System.exit(1);
        }
    }

    private void test(String testFile) throws IOException {
        String line;
        long startTime = System.currentTimeMillis();
        this.indexDir = Path.resolveRelOrAbs(new File(".").getAbsoluteFile(), "index");
        XtfSearcher searcher = DefaultQueryProcessor.getXtfSearcher(this.indexDir);
        SpellReader spellReader = searcher.spellReader();
        PrintWriter debugWriter = new PrintWriter(new FileWriter("spellDebug.log"));
        spellReader.setDebugWriter(debugWriter);
        BufferedReader lineReader = new BufferedReader(new FileReader(testFile));
        int nTried = 0;
        int nCorrect = 0;
        while ((line = lineReader.readLine()) != null) {
            String[] parts = (line = line.replaceFirst(";.*", "")).split("->");
            if (parts.length != 2) {
                System.out.println("Unrecognized test line: " + line);
                continue;
            }
            String origPhrase = parts[0].trim();
            String correctPhraseStr = parts[1].trim();
            String[] correctPhrases = correctPhraseStr.split("\\|");
            debugWriter.println("orig=\"" + origPhrase + "\", corr=\"" + correctPhraseStr + "\"");
            String suggPhrase = this.testPhrase(origPhrase, debugWriter);
            ++nTried;
            debugWriter.print("--> sugg=\"" + suggPhrase + "\"");
            boolean correct = false;
            for (int i = 0; i < correctPhrases.length; ++i) {
                correct |= correctPhrases[i].equalsIgnoreCase(suggPhrase);
            }
            if (!correct) {
                debugWriter.print("  WRONG");
                System.out.println("orig=\"" + origPhrase + "\", corr=\"" + correctPhraseStr + "\", sugg=\"" + suggPhrase + "\"");
            } else {
                ++nCorrect;
            }
            debugWriter.println();
            if (nTried != 1) continue;
            debugWriter.println("Time to first word: " + (System.currentTimeMillis() - startTime) + " msec");
        }
        System.out.println();
        System.out.print("**TOTAL** ");
        System.out.printf("%.1f%%", (double)nCorrect * 100.0 / (double)nTried);
        System.out.println();
        System.out.println("Done. Total time: " + (System.currentTimeMillis() - startTime) + " msec");
        lineReader.close();
        spellReader.close();
        debugWriter.close();
    }

    private String testPhrase(String origPhrase, PrintWriter debugWriter) throws IOException {
        String[] origWords = this.split(origPhrase);
        StringBuffer buf = new StringBuffer();
        buf.append("<query indexPath=\"index\" termLimit=\"1000\" workLimit=\"20000000\" style=\"style/crossQuery/resultFormatter/marc/resultFormatter.xsl\" startDoc=\"1\" maxDocs=\"20\" normalizeScores=\"false\">\n<spellcheck suggestionsPerTerm=\"1\" totalDocsCutoff=\"1000\" fields=\"text,title-main,author,subject,note\"/>\n<and fields=\"text title-main author subject note\" boosts=\"0.5  1.0        1.0    0.5     1.0 \" slop=\"10\" maxTextSnippets=\"3\" maxMetaSnippets=\"all\">\n");
        for (String s : origWords) {
            buf.append("<term>" + s + "</term>\n");
        }
        buf.append("</and></query>");
        QueryRequestParser parser = new QueryRequestParser();
        StreamSource src = new StreamSource(new StringReader(buf.toString()));
        QueryRequest req = parser.parseRequest(src, new File(".").getAbsoluteFile(), this.indexDir);
        DefaultQueryProcessor queryProcessor = new DefaultQueryProcessor();
        QueryResult res = queryProcessor.processRequest(req);
        if (res.suggestions == null || res.suggestions.length == 0) {
            return null;
        }
        Object[] suggWords = new String[origWords.length];
        for (int i = 0; i < origWords.length; ++i) {
            suggWords[i] = origWords[i];
            for (int j = 0; j < res.suggestions.length; ++j) {
                if (!res.suggestions[j].origTerm.equals(origWords[i])) continue;
                suggWords[i] = res.suggestions[j].suggestedTerm;
            }
        }
        return StringUtil.join(suggWords);
    }

    public String[] split(String in) throws ParseException, IOException {
        Token t;
        XTFTokenizer toks = new XTFTokenizer(new StringReader(in));
        ArrayList<String> list = new ArrayList<String>();
        while ((t = toks.next()) != null) {
            list.add(t.termText());
        }
        return list.toArray(new String[list.size()]);
    }
}

