/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class SimpleQueryRewriter {
    public Query rewriteQuery(Query q) {
        if (q instanceof BooleanQuery) {
            return this.rewrite((BooleanQuery)q);
        }
        if (q instanceof PhraseQuery) {
            return this.rewrite((PhraseQuery)q);
        }
        if (q instanceof TermQuery) {
            return this.rewrite((TermQuery)q);
        }
        return q;
    }

    protected Query rewrite(BooleanQuery bq) {
        BooleanClause clause;
        ArrayList<BooleanClause> newClauses = new ArrayList<BooleanClause>();
        boolean anyChange = false;
        for (BooleanClause oldClause : bq.getClauses()) {
            Query rewritten = this.rewriteQuery(oldClause.getQuery());
            if (rewritten != oldClause.getQuery()) {
                anyChange = true;
                if (rewritten == null) continue;
                newClauses.add(new BooleanClause(rewritten, oldClause.getOccur()));
                continue;
            }
            newClauses.add(oldClause);
        }
        if (!anyChange) {
            return bq;
        }
        if (newClauses.isEmpty()) {
            return null;
        }
        if (newClauses.size() == 1 && (clause = (BooleanClause)newClauses.get(0)).getOccur() != BooleanClause.Occur.MUST_NOT) {
            Query newq = clause.getQuery();
            newq.setBoost(Math.max(bq.getBoost(), newq.getBoost()));
            return newq;
        }
        bq = new BooleanQuery(bq.isCoordDisabled());
        bq.setBoost(bq.getBoost());
        for (BooleanClause newClause : newClauses) {
            bq.add(newClause);
        }
        return bq;
    }

    protected Query rewrite(PhraseQuery pq) {
        Term[] oldTerms = pq.getTerms();
        ArrayList<Term> newTerms = new ArrayList<Term>();
        boolean anyChange = false;
        for (int i = 0; i < oldTerms.length; ++i) {
            Term newTerm = this.rewrite(oldTerms[i]);
            if (newTerm != oldTerms[i]) {
                anyChange = true;
                if (newTerm == null) continue;
                int spacePos = newTerm.text().indexOf(32);
                if (oldTerms[i].text().indexOf(32) < 0 && spacePos >= 0) {
                    newTerms.add(new Term(newTerm.field(), newTerm.text().substring(0, spacePos)));
                    newTerms.add(new Term(newTerm.field(), newTerm.text().substring(spacePos + 1)));
                    continue;
                }
                newTerms.add(newTerm);
                continue;
            }
            newTerms.add(oldTerms[i]);
        }
        if (!anyChange) {
            return pq;
        }
        if (newTerms.size() == 0) {
            return null;
        }
        if (newTerms.size() == 1) {
            TermQuery newq = new TermQuery((Term)newTerms.get(0));
            newq.setBoost(pq.getBoost());
            return newq;
        }
        PhraseQuery newq = new PhraseQuery();
        newq.setBoost(pq.getBoost());
        newq.setSlop(pq.getSlop());
        for (int i = 0; i < newTerms.size(); ++i) {
            newq.add((Term)newTerms.get(i));
        }
        return newq;
    }

    protected Query rewrite(TermQuery q) {
        Term newTerm;
        Term oldTerm = q.getTerm();
        if (oldTerm == (newTerm = this.rewrite(oldTerm))) {
            return q;
        }
        if (newTerm == null) {
            return null;
        }
        int spacePos = newTerm.text().indexOf(32);
        if (oldTerm.text().indexOf(32) < 0 && spacePos >= 0) {
            PhraseQuery pq = new PhraseQuery();
            pq.add(new Term(newTerm.field(), newTerm.text().substring(0, spacePos)));
            pq.add(new Term(newTerm.field(), newTerm.text().substring(spacePos + 1)));
            pq.setBoost(q.getBoost());
            return pq;
        }
        TermQuery newQuery = new TermQuery(newTerm);
        newQuery.setBoost(q.getBoost());
        return newQuery;
    }

    protected Term rewrite(Term t) {
        return t;
    }
}

