/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.spelt.DoubleMetaphone;
import org.apache.lucene.spelt.FreqData;
import org.apache.lucene.util.CountedInputStream;
import org.apache.lucene.util.CountedOutputStream;
import org.apache.lucene.util.FileSorter;
import org.apache.lucene.util.IntList;
import org.apache.lucene.util.ProgressTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellWriter {
    private File spellIndexDir;
    private Set stopSet = null;
    private File wordQueueFile;
    private String prevWord;
    private File pairQueueFile;
    private File freqFile;
    private File sampleFile;
    private File edmapFile;
    private File pairFreqFile;
    private PrintWriter wordQueueWriter = null;
    private PrintWriter pairQueueWriter = null;
    private static final int MAX_RECENT_WORDS = 20000;
    private HashMap<String, Integer> recentWords = new HashMap(20000);
    private static final int MAX_RECENT_PAIRS = 200000;
    private HashMap<String, Integer> recentPairs = new HashMap(200000);
    private static final int DEFAULT_MIN_WORD_FREQ = 2;
    private int minWordFreq = 2;
    private static final int DEFAULT_MIN_PAIR_FREQ = 2;
    private int minPairFreq = 2;
    private static DoubleMetaphone doubleMetaphone = new DoubleMetaphone();
    Pattern splitPat = Pattern.compile("\\|");
    private int SORT_MEM_LIMIT = 0x6400000;
    private char[] keyChars = new char[4];
    private StringBuffer edmapBuf = new StringBuffer();

    private SpellWriter() {
    }

    public static SpellWriter open(File spellIndexDir) throws IOException {
        SpellWriter writer = new SpellWriter();
        writer.openInternal(spellIndexDir);
        return writer;
    }

    private void openInternal(File spellIndexDir) throws IOException {
        this.spellIndexDir = spellIndexDir;
        this.wordQueueFile = new File(spellIndexDir, "newWords.txt");
        this.pairQueueFile = new File(spellIndexDir, "newPairs.txt");
        this.freqFile = new File(spellIndexDir, "words.dat");
        this.sampleFile = new File(spellIndexDir, "freqSamples.dat");
        this.edmapFile = new File(spellIndexDir, "edmap.dat");
        this.pairFreqFile = new File(spellIndexDir, "pairs.dat");
        if (!spellIndexDir.isDirectory() && !spellIndexDir.mkdir()) {
            throw new IOException("Error creating spelling index directory");
        }
    }

    public void setStopwords(Set set) {
        this.stopSet = set;
    }

    public void setMinWordFreq(int freq) {
        this.minWordFreq = freq;
    }

    public void setMinPairFreq(int freq) {
        this.minPairFreq = freq;
    }

    public synchronized void close() throws IOException {
        this.closeQueueWriters();
    }

    public synchronized void clearDictionary() throws IOException {
        this.close();
        this.wordQueueFile.delete();
        this.pairQueueFile.delete();
        this.freqFile.delete();
        this.sampleFile.delete();
        this.edmapFile.delete();
        this.pairFreqFile.delete();
        this.recentWords.clear();
        this.recentPairs.clear();
    }

    public synchronized void queueWord(String word) throws IOException {
        word = word.toLowerCase();
        if (this.stopSet != null && this.stopSet.contains(word)) {
            return;
        }
        if (this.prevWord != null) {
            String key = this.prevWord + "|" + word;
            Integer val = this.recentPairs.get(key);
            val = val == null ? Integer.valueOf(1) : Integer.valueOf(val + 1);
            this.recentPairs.put(key, val);
            if (this.recentPairs.size() >= 200000) {
                this.flushRecentPairs();
            }
        }
        this.prevWord = word;
        Integer val = this.recentWords.get(word);
        val = val == null ? Integer.valueOf(1) : Integer.valueOf(val + 1);
        this.recentWords.put(word, val);
        if (this.recentWords.size() >= 20000) {
            this.flushRecentWords();
        }
    }

    public void queueBreak() {
        this.prevWord = null;
    }

    private void flushRecentPairs() throws IOException {
        if (this.recentPairs.isEmpty()) {
            return;
        }
        this.openPairQueueWriter();
        Set<String> keySet = this.recentPairs.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            int count = this.recentPairs.get(key);
            if (count < this.minPairFreq) continue;
            this.pairQueueWriter.println(key + "|" + count);
        }
        this.pairQueueWriter.flush();
        this.recentPairs.clear();
    }

    private void flushRecentWords() throws IOException {
        if (this.recentWords.isEmpty()) {
            return;
        }
        this.openWordQueueWriter();
        Set<String> keySet = this.recentWords.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            int count = this.recentWords.get(key);
            this.wordQueueWriter.println(key + "|" + count);
        }
        this.wordQueueWriter.flush();
        this.recentWords.clear();
    }

    public synchronized boolean anyWordsQueued() throws IOException {
        this.closeQueueWriters();
        long queueSize = this.wordQueueFile.length();
        return queueSize > 1L;
    }

    public synchronized void flushQueuedWords() throws IOException {
        this.flushQueuedWords(null);
    }

    public synchronized void flushQueuedWords(ProgressTracker prog) throws IOException {
        this.closeQueueWriters();
        if (prog == null) {
            prog = new ProgressTracker(){

                public void report(int pctDone, String descrip) {
                }
            };
        }
        ProgressTracker[] phaseProgs = prog.split((this.freqFile.length() + this.wordQueueFile.length()) * 10L, this.pairQueueFile.length());
        this.flushPhase1(phaseProgs[0]);
        this.flushPhase2(phaseProgs[1]);
        prog.progress(100L, 100L, "Done.", true);
    }

    private void flushPhase1(ProgressTracker prog) throws IOException {
        if (!this.wordQueueFile.canRead()) {
            return;
        }
        ProgressTracker[] subProgs = prog.split(5L, 30L, 5L, 60L);
        ProgressTracker[] wordProgs = subProgs[0].split(this.freqFile.length(), this.wordQueueFile.length());
        FileSorter freqSorter = FileSorter.start(this.spellIndexDir, this.SORT_MEM_LIMIT);
        this.readFreqs(this.freqFile, freqSorter, wordProgs[0]);
        this.readFreqs(this.wordQueueFile, freqSorter, wordProgs[1]);
        File newFreqFile = new File(this.spellIndexDir, "words.dat.new");
        FileSorter edmapSorter = FileSorter.start(this.spellIndexDir, this.SORT_MEM_LIMIT);
        IntList allFreqs = new IntList(10000);
        this.writeFreqs(newFreqFile, freqSorter, allFreqs, edmapSorter, subProgs[1]);
        File newSampleFile = new File(this.spellIndexDir, "freqSamples.dat.new");
        this.writeFreqSamples(allFreqs, newSampleFile, subProgs[2]);
        File newEdmapFile = new File(this.spellIndexDir, "edmap.dat.new");
        this.writeEdMap(edmapSorter, newEdmapFile, subProgs[3]);
        this.replaceFile(this.freqFile, newFreqFile);
        this.replaceFile(this.sampleFile, newSampleFile);
        this.replaceFile(this.edmapFile, newEdmapFile);
        this.deleteFile(this.wordQueueFile);
    }

    private void readFreqs(File inFile, FileSorter out, ProgressTracker prog) throws IOException {
        String line;
        if (!inFile.canRead()) {
            return;
        }
        CountedInputStream countedIn = new CountedInputStream(new FileInputStream(inFile));
        BufferedReader freqReader = new BufferedReader(new InputStreamReader((InputStream)countedIn, "UTF-8"));
        int lineCt = 0;
        while ((line = freqReader.readLine()) != null) {
            out.addLine(line);
            if ((lineCt++ & 0xFFF) != 0) continue;
            prog.progress(countedIn.nRead(), inFile.length(), "Reading word files.");
        }
        freqReader.close();
    }

    private void writeFreqs(File outFile, final FileSorter freqSorter, final IntList allFreqs, final FileSorter edmapSorter, final ProgressTracker prog) throws IOException {
        final BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        freqSorter.finish(new FileSorter.Output(){
            String curWord = null;
            int curFreq = 0;
            int nProcessed = 0;

            public void writeLine(String line) throws IOException {
                String[] tokens = SpellWriter.this.splitPat.split(line);
                if (tokens.length == 2) {
                    if (!tokens[0].equals(this.curWord)) {
                        if (this.curWord != null) {
                            this.flushWord();
                        }
                        this.curWord = tokens[0];
                    }
                    try {
                        this.curFreq += Integer.parseInt(tokens[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if ((this.nProcessed++ & 0xFFF) == 0 && this.nProcessed > 1) {
                        prog.progress(this.nProcessed, freqSorter.nLinesAdded(), "Processed " + this.nProcessed + " words.");
                    }
                }
            }

            private void flushWord() throws IOException {
                if (this.curFreq < SpellWriter.this.minWordFreq) {
                    return;
                }
                allFreqs.add(this.curFreq);
                out.append(this.curWord);
                out.append('|');
                out.append(Integer.toString(this.curFreq));
                out.append('\n');
                SpellWriter.this.addCombos(this.curWord, edmapSorter);
                this.curFreq = 0;
            }

            public void close() throws IOException {
                out.close();
                prog.progress(this.nProcessed, freqSorter.nLinesAdded(), "Processed " + this.nProcessed + " words.", true);
            }
        });
    }

    private void addCombos(String word, FileSorter edMapSorter) throws IOException {
        this.addCombo(word, edMapSorter, 0, 1, 2, 3);
        this.addCombo(word, edMapSorter, 0, 1, 2, 4);
        this.addCombo(word, edMapSorter, 0, 1, 2, 5);
        this.addCombo(word, edMapSorter, 0, 1, 3, 4);
        this.addCombo(word, edMapSorter, 0, 1, 3, 5);
        this.addCombo(word, edMapSorter, 0, 1, 4, 5);
        this.addCombo(word, edMapSorter, 0, 2, 3, 4);
        this.addCombo(word, edMapSorter, 0, 2, 3, 5);
        this.addCombo(word, edMapSorter, 0, 2, 4, 5);
        this.addCombo(word, edMapSorter, 0, 3, 4, 5);
        if (word.length() > 1) {
            this.addCombo(word, edMapSorter, 1, 2, 3, 4);
            this.addCombo(word, edMapSorter, 1, 2, 3, 5);
            this.addCombo(word, edMapSorter, 1, 2, 4, 5);
            this.addCombo(word, edMapSorter, 1, 3, 4, 5);
            if (word.length() > 2) {
                this.addCombo(word, edMapSorter, 2, 3, 4, 5);
            }
        }
    }

    private void addCombo(String word, FileSorter edmapSorter, int p0, int p1, int p2, int p3) throws IOException {
        this.edmapBuf.setLength(0);
        this.edmapBuf.append(this.comboKey(word, p0, p1, p2, p3));
        this.edmapBuf.append('|');
        this.edmapBuf.append(word);
        String line = this.edmapBuf.toString();
        edmapSorter.addLine(line);
    }

    private char[] comboKey(String word, int p0, int p1, int p2, int p3) {
        this.keyChars[0] = word.length() > p0 ? (int)this.comboChar(word.charAt(p0)) : 32;
        this.keyChars[1] = word.length() > p1 ? (int)this.comboChar(word.charAt(p1)) : 32;
        this.keyChars[2] = word.length() > p2 ? (int)this.comboChar(word.charAt(p2)) : 32;
        this.keyChars[3] = word.length() > p3 ? (int)this.comboChar(word.charAt(p3)) : 32;
        return this.keyChars;
    }

    private char comboChar(char c) {
        if (c >= ' ' && (c & 0xFFFFFF80) == 0) {
            return c;
        }
        return (c = (char)(c & 0x7F | 0x20)) == '|' ? (char)'*' : (char)c;
    }

    private void writeFreqSamples(IntList allFreqs, File file, ProgressTracker prog) throws IOException {
        IntList finalFreqs;
        prog.progress(0L, 100L, "Sampling frequencies.");
        long totalFreq = 0L;
        for (int i = 0; i < allFreqs.size(); ++i) {
            totalFreq += (long)allFreqs.get(i);
        }
        double avgFreq = (double)totalFreq / (double)allFreqs.size();
        prog.progress(10L, 100L, "Sampling frequencies.");
        IntList aboveAvgFreqs = new IntList(allFreqs.size() / 2);
        for (int i = 0; i < allFreqs.size(); ++i) {
            int freq = allFreqs.get(i);
            if (!((double)freq > avgFreq)) continue;
            aboveAvgFreqs.add(freq);
        }
        prog.progress(20L, 100L, "Sampling frequencies.");
        aboveAvgFreqs.sort();
        int MAX_SAMPLES = 1000;
        if (aboveAvgFreqs.size() < 1000) {
            finalFreqs = aboveAvgFreqs;
        } else {
            finalFreqs = new IntList(1000);
            for (int i = 0; i < 1000; ++i) {
                int pos = (int)((long)i * (long)aboveAvgFreqs.size() / 1000L);
                finalFreqs.add(aboveAvgFreqs.get(pos));
            }
        }
        if (finalFreqs.size() > 0) {
            finalFreqs.set(0, (int)avgFreq);
        }
        prog.progress(50L, 100L, "Sampling frequencies.");
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println(allFreqs.size());
        writer.println(finalFreqs.size());
        for (int i = 0; i < finalFreqs.size(); ++i) {
            writer.println(finalFreqs.get(i));
        }
        writer.close();
        prog.progress(100L, 100L, "Sampling frequencies.");
    }

    private void writeEdMap(final FileSorter edmapSorter, File outFile, final ProgressTracker prog) throws IOException {
        final CountedOutputStream outCounted = new CountedOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        final OutputStreamWriter out = new OutputStreamWriter((OutputStream)outCounted, "UTF-8");
        prog.progress(0L, 100L, "Building word map.", true);
        final ArrayList edKeys = new ArrayList();
        final IntList sizes = new IntList();
        edmapSorter.finish(new FileSorter.Output(){
            String curKey = null;
            ArrayList<String> curWords = new ArrayList();
            int nWritten = 0;

            public void writeLine(String line) throws IOException {
                String[] tokens = SpellWriter.this.splitPat.split(line);
                assert (tokens.length == 2) : "invalid edmap line";
                if (!tokens[0].equals(this.curKey)) {
                    if (this.curKey != null) {
                        this.flushKey();
                    }
                    this.curKey = tokens[0];
                }
                this.curWords.add(tokens[1]);
                if ((this.nWritten++ & 0xFFF) == 0) {
                    prog.progress(this.nWritten, edmapSorter.nLinesAdded(), "Building word map.");
                }
            }

            private void flushKey() throws IOException {
                long prevPos = outCounted.nWritten();
                SpellWriter.this.condenseEdmapKey(this.curKey, this.curWords, out);
                out.flush();
                edKeys.add(this.curKey);
                sizes.add((int)(outCounted.nWritten() - prevPos));
                this.curWords.clear();
            }

            public void close() {
            }
        });
        long indexPos = outCounted.nWritten();
        ((Writer)out).append("edMap index\n");
        ((Writer)out).append(Integer.toString(edKeys.size()));
        out.append('\n');
        for (int i = 0; i < edKeys.size(); ++i) {
            String key = (String)edKeys.get(i);
            ((Writer)out).append(key);
            out.append('|');
            ((Writer)out).append(Integer.toString(sizes.get(i)));
            out.append('\n');
        }
        String tmp = Long.toString(indexPos);
        while (tmp.length() < 20) {
            tmp = " " + tmp;
        }
        ((Writer)out).append(tmp);
        ((Writer)out).close();
    }

    private void condenseEdmapKey(String key, ArrayList<String> words, Writer out) throws IOException {
        String prev = words.get(0);
        out.append(key);
        out.append('|');
        out.append(prev);
        for (int j = 1; j < words.size(); ++j) {
            int k;
            String word = words.get(j);
            if (word.equals(prev)) continue;
            for (k = 0; k < Math.min(prev.length(), word.length()) && word.charAt(k) == prev.charAt(k); ++k) {
            }
            out.append('|');
            out.append((char)(48 + k));
            out.append(word.substring(k));
            prev = word;
        }
        out.append('\n');
    }

    private void deleteFile(File file) throws IOException {
        if (file.delete()) {
            return;
        }
        FileOutputStream tmp = new FileOutputStream(file);
        tmp.close();
    }

    private void replaceFile(File oldFile, File newFile) {
        oldFile.delete();
        newFile.renameTo(oldFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPhase2(ProgressTracker prog) throws IOException {
        if (!this.pairQueueFile.canRead()) {
            return;
        }
        FreqData pairData = new FreqData();
        if (this.pairFreqFile.canRead()) {
            pairData.add(this.pairFreqFile);
        }
        CountedInputStream queueCounted = new CountedInputStream(new FileInputStream(this.pairQueueFile));
        BufferedReader queueReader = new BufferedReader(new InputStreamReader((InputStream)queueCounted, "UTF-8"));
        ProgressTracker[] subProgs = prog.split(90L, 10L);
        long fileTotal = this.pairQueueFile.length();
        int totalAdded = 0;
        try {
            boolean eof = false;
            while (!eof) {
                String line = queueReader.readLine();
                if (line == null) {
                    eof = true;
                    break;
                }
                String[] tokens = this.splitPat.split(line);
                if (tokens.length != 3) continue;
                String word1 = tokens[0];
                String word2 = tokens[1];
                String countTxt = tokens[2];
                try {
                    pairData.add(word1, word2, Integer.parseInt(countTxt));
                    if ((++totalAdded & 0xFFF) != 0) continue;
                    long filePos = queueCounted.nRead();
                    subProgs[0].progress(filePos + 1L, fileTotal + 1L, "Read " + totalAdded + " pairs.");
                }
                catch (NumberFormatException e) {}
            }
            subProgs[0].progress(100L, 100L, "Read " + totalAdded + " pairs.", true);
        }
        finally {
            queueReader.close();
            queueCounted.close();
        }
        File newPairFreqFile = new File(this.spellIndexDir, "pairs.dat.new");
        newPairFreqFile.delete();
        subProgs[1].progress(50L, 100L, "Writing pair data.", true);
        pairData.save(newPairFreqFile);
        if (this.pairFreqFile.canRead() && !this.pairFreqFile.delete()) {
            throw new IOException("Could not delete old pair data file -- permission problem?");
        }
        if (!newPairFreqFile.renameTo(this.pairFreqFile)) {
            throw new IOException("Could not rename new pair data file -- permission problem?");
        }
        FileOutputStream tmp = new FileOutputStream(this.pairQueueFile);
        tmp.close();
        this.pairQueueFile.delete();
    }

    private void openWordQueueWriter() throws IOException {
        if (this.wordQueueWriter != null) {
            return;
        }
        this.wordQueueWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.wordQueueFile, true), "UTF-8")));
    }

    private void openPairQueueWriter() throws IOException {
        if (this.pairQueueWriter != null) {
            return;
        }
        this.pairQueueWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.pairQueueFile, true), "UTF-8")));
    }

    private void closeQueueWriters() throws IOException {
        this.flushRecentWords();
        if (this.wordQueueWriter != null) {
            this.wordQueueWriter.close();
            this.wordQueueWriter = null;
        }
        this.flushRecentPairs();
        if (this.pairQueueWriter != null) {
            this.pairQueueWriter.close();
            this.pairQueueWriter = null;
        }
    }

    public static String calcMetaphone(String word) {
        return doubleMetaphone.doubleMetaphone(word);
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

