/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSIndexInput;
import org.apache.lucene.store.FSIndexOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;

public class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private static final char[] HEX_DIGITS;

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path) throws IOException {
        return FSDirectory.getDirectory(new File(path), null);
    }

    public static FSDirectory getDirectory(String path, LockFactory lockFactory) throws IOException {
        return FSDirectory.getDirectory(new File(path), lockFactory);
    }

    public static FSDirectory getDirectory(File file) throws IOException {
        return FSDirectory.getDirectory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, LockFactory lockFactory) throws IOException {
        FSDirectory dir;
        if ((file = new File(file.getCanonicalPath())).exists() && !file.isDirectory()) {
            throw new IOException(file + " not a directory");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory: " + file);
        }
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                try {
                    dir = (FSDirectory)IMPL.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
                }
                dir.init(file, lockFactory);
                DIRECTORIES.put(file, dir);
            } else if (lockFactory != null && lockFactory != dir.getLockFactory()) {
                throw new IOException("Directory was previously created with a different LockFactory instance; please pass null as the lockFactory instance and use setLockFactory to change it");
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(file, null);
        if (create) {
            dir.create();
        }
        return dir;
    }

    private void create() throws IOException {
        if (this.directory.exists()) {
            String[] files = this.directory.list(IndexFileNameFilter.getFilter());
            if (files == null) {
                throw new IOException("Cannot read directory " + this.directory.getAbsolutePath());
            }
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.directory, files[i]);
                if (file.delete()) continue;
                throw new IOException("Cannot delete " + file);
            }
        }
        this.lockFactory.clearLock("write.lock");
    }

    protected FSDirectory() {
    }

    private void init(File path, LockFactory lockFactory) throws IOException {
        this.directory = path;
        boolean doClearLockID = false;
        if (lockFactory == null) {
            if (disableLocks) {
                lockFactory = NoLockFactory.getNoLockFactory();
            } else {
                String lockClassName = System.getProperty("org.apache.lucene.store.FSDirectoryLockFactoryClass");
                if (lockClassName != null && !lockClassName.equals("")) {
                    Class<?> c;
                    try {
                        c = Class.forName(lockClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("unable to find LockClass " + lockClassName);
                    }
                    try {
                        lockFactory = (LockFactory)c.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException("IllegalAccessException when instantiating LockClass " + lockClassName);
                    }
                    catch (InstantiationException e) {
                        throw new IOException("InstantiationException when instantiating LockClass " + lockClassName);
                    }
                    catch (ClassCastException e) {
                        throw new IOException("unable to cast LockClass " + lockClassName + " instance to a LockFactory");
                    }
                }
                lockFactory = new SimpleFSLockFactory(path);
                doClearLockID = true;
            }
        }
        this.setLockFactory(lockFactory);
        if (doClearLockID) {
            lockFactory.setLockPrefix(null);
        }
    }

    public String[] list() {
        return this.directory.list(IndexFileNameFilter.getFilter());
    }

    public boolean fileExists(String name) {
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameFile(String from, String to) throws IOException {
        File old = new File(this.directory, from);
        File nu = new File(this.directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (old.renameTo(nu)) return;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                int len;
                in = new FileInputStream(old);
                out = new FileOutputStream(nu);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((len = ((InputStream)in).read(this.buffer)) >= 0) {
                    ((OutputStream)out).write(this.buffer, 0, len);
                }
                old.delete();
            }
            catch (IOException ioe) {
                IOException newExc = new IOException("Cannot rename " + old + " to " + nu);
                newExc.initCause(ioe);
                throw newExc;
            }
            Object var10_9 = null;
            try {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                    }
                }
                Object var13_13 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (out == null) throw throwable;
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                }
                ((OutputStream)out).close();
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {}
            catch (Throwable throwable2) {
                Object var13_16 = null;
                if (out == null) throw throwable2;
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                }
                ((OutputStream)out).close();
                throw throwable2;
            }
            if (in != null) {
                try {}
                catch (IOException e) {
                    throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                }
                ((InputStream)in).close();
            }
            Object var13_15 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException e) {
                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
            }
            ((OutputStream)out).close();
            throw throwable;
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.directory, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockID() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.directory;
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.FSDirectory.class", FSDirectory.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(FSDirectory.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default FSDirectory class: " + e.toString(), e);
            }
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString(), e);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

