/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public class IntList {
    private int[] data;
    private int size = 0;

    public IntList() {
        this(10);
    }

    public IntList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public final void add(int value) {
        if (this.size == this.data.length) {
            this.resize(Math.max(this.size + 5, this.size * 3 / 2));
        }
        this.data[this.size++] = value;
    }

    public final void ensureCapacity(int cap) {
        if (cap > this.data.length) {
            this.resize(cap);
        }
    }

    public final void compact() {
        this.resize(this.size);
    }

    public final void resize(int newSize) {
        if (newSize != this.data.length) {
            int[] oldData = this.data;
            this.data = new int[newSize];
            System.arraycopy(oldData, 0, this.data, 0, Math.min(this.size, newSize));
            this.size = Math.min(this.size, newSize);
        }
    }

    public final int[] toArray() {
        int[] ret = new int[this.size];
        System.arraycopy(this.data, 0, ret, 0, this.size);
        return ret;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    public final int get(int index) {
        return this.data[index];
    }

    public final int getLast() {
        return this.data[this.size - 1];
    }

    public final void set(int index, int value) {
        this.data[index] = value;
    }

    public final void fill(int value) {
        Arrays.fill(this.data, value);
    }

    public final void sort() {
        this.compact();
        Arrays.sort(this.data);
    }

    public final int binarySearch(int searchFor) {
        this.compact();
        return Arrays.binarySearch(this.data, searchFor);
    }

    public final int[] calcSortMap() {
        int i;
        int[] map = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            if (this.data[i] < 0) {
                throw new RuntimeException("This radix-sort cannot handle negative numbers");
            }
            map[i] = i;
        }
        int MAX_BITS = 32;
        short[] curByte = new short[this.size];
        int[] count = new int[256];
        int[] newMap = new int[this.size];
        for (int shift = 0; shift < 32; shift += 8) {
            Arrays.fill(count, 0);
            for (i = 0; i < this.size; ++i) {
                curByte[i] = (short)(this.data[map[i]] >> shift & 0xFF);
                count[curByte[i]] = count[curByte[i]] + 1;
            }
            int pos = 0;
            for (i = 0; i < 256; ++i) {
                int tmp = pos;
                pos += count[i];
                count[i] = tmp;
            }
            for (i = 0; i < this.size; ++i) {
                short s = curByte[i];
                int n = count[s];
                count[s] = n + 1;
                newMap[n] = map[i];
            }
            int[] tmp = map;
            map = newMap;
            newMap = tmp;
        }
        int prev = Integer.MIN_VALUE;
        for (i = 0; i < this.size; ++i) {
            int tmp = this.data[map[i]];
            if (tmp < prev) {
                throw new RuntimeException("Fatal internal error: sort algorithm has a bug");
            }
            prev = tmp;
        }
        return map;
    }

    public final void remap(int[] map) {
        int[] newData = new int[this.size];
        assert (map.length == this.size);
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[map[i]];
        }
        this.data = newData;
    }
}

