/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern spacePat = Pattern.compile("\\s+");

    public static String join(Object[] in) {
        return StringUtil.join(in, " ");
    }

    public static String join(Object[] in, String separator) {
        if (in == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(in[i].toString());
        }
        return buf.toString();
    }

    public static String padEnd(String in, int len) {
        return StringUtil.padEnd(in, len, ' ');
    }

    public static String justifyLeft(String in, int len) {
        return StringUtil.padEnd(in, len, ' ');
    }

    public static String padEnd(String in, int len, char padChar) {
        if (in.length() >= len) {
            return in;
        }
        StringBuffer buf = new StringBuffer(len);
        buf.append(in);
        for (int i = 0; i < len - in.length(); ++i) {
            buf.append(padChar);
        }
        return buf.toString();
    }

    public static String padStart(String in, int len) {
        return StringUtil.padStart(in, len, ' ');
    }

    public static String justifyRight(String in, int len) {
        return StringUtil.padStart(in, len, ' ');
    }

    public static String padStart(String in, int len, char padChar) {
        if (in.length() >= len) {
            return in;
        }
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len - in.length(); ++i) {
            buf.append(padChar);
        }
        buf.append(in);
        return buf.toString();
    }

    public static String copyCase(String pattern, String in) {
        if (StringUtil.isLowerCase(pattern)) {
            return in.toLowerCase();
        }
        if (StringUtil.isUpperCase(pattern)) {
            return in.toUpperCase();
        }
        if (StringUtil.isTitleCase(pattern)) {
            return StringUtil.toTitleCase(in);
        }
        return in;
    }

    public static boolean isUpperCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        for (int i = 0; i < in.length(); ++i) {
            if (Character.isUpperCase(in.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        for (int i = 0; i < in.length(); ++i) {
            if (Character.isLowerCase(in.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTitleCase(String in) {
        if (in == null || in.length() == 0) {
            return false;
        }
        String[] words = StringUtil.splitWords(in);
        if (words.length == 1) {
            String word = words[0];
            if (word.length() <= 1) {
                return false;
            }
            return Character.isUpperCase(word.charAt(0)) && StringUtil.isLowerCase(word.substring(1));
        }
        for (int i = 0; i < words.length; ++i) {
            if (StringUtil.isTitleCase(words[i])) continue;
            return false;
        }
        return true;
    }

    public static String toTitleCase(String in) {
        String[] words = StringUtil.splitWords(in);
        if (words.length == 0) {
            return in;
        }
        if (words.length == 1) {
            String word = words[0];
            if (word.length() < 1) {
                return word;
            }
            return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
        }
        Object[] converted = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            converted[i] = StringUtil.toTitleCase(words[i]);
        }
        return StringUtil.join(converted);
    }

    public static String[] splitWords(String in) {
        if (in == null) {
            return new String[0];
        }
        String trimmed = in.trim();
        if (trimmed.length() == 0) {
            return new String[0];
        }
        return spacePat.split(trimmed);
    }

    public static String escapeHTMLChars(String in) {
        StringBuffer buf = new StringBuffer(in.length());
        block40: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c >= '\u0000' && c <= '\u001f' && c != '\t' && c != '\u000b' && c != '\r') continue;
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block40;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block40;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block40;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block40;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block40;
                }
                case '\n': {
                    buf.append("<br/>\n");
                    continue block40;
                }
                case '\u0080': {
                    buf.append("\u20ac");
                    continue block40;
                }
                case '\u0081': {
                    buf.append("\u0081");
                    continue block40;
                }
                case '\u0082': {
                    buf.append("\u201a");
                    continue block40;
                }
                case '\u0083': {
                    buf.append("\u0192");
                    continue block40;
                }
                case '\u0084': {
                    buf.append("\u201e");
                    continue block40;
                }
                case '\u0085': {
                    buf.append("\u2026");
                    continue block40;
                }
                case '\u0086': {
                    buf.append("\u2020");
                    continue block40;
                }
                case '\u0087': {
                    buf.append("\u2021");
                    continue block40;
                }
                case '\u0088': {
                    buf.append("\u02c6");
                    continue block40;
                }
                case '\u0089': {
                    buf.append("\u2030");
                    continue block40;
                }
                case '\u008a': {
                    buf.append("\u0160");
                    continue block40;
                }
                case '\u008b': {
                    buf.append("\u2039");
                    continue block40;
                }
                case '\u008c': {
                    buf.append("\u0152");
                    continue block40;
                }
                case '\u008d': {
                    buf.append("\u008d");
                    continue block40;
                }
                case '\u008e': {
                    buf.append("\u017d");
                    continue block40;
                }
                case '\u008f': {
                    buf.append("\u008f");
                    continue block40;
                }
                case '\u0090': {
                    buf.append("\u0090");
                    continue block40;
                }
                case '\u0091': {
                    buf.append("\u2018");
                    continue block40;
                }
                case '\u0092': {
                    buf.append("\u2019");
                    continue block40;
                }
                case '\u0093': {
                    buf.append("\u201c");
                    continue block40;
                }
                case '\u0094': {
                    buf.append("\u201d");
                    continue block40;
                }
                case '\u0095': {
                    buf.append("\u2022");
                    continue block40;
                }
                case '\u0096': {
                    buf.append("\u2013");
                    continue block40;
                }
                case '\u0097': {
                    buf.append("\u2014");
                    continue block40;
                }
                case '\u0098': {
                    buf.append("\u02dc");
                    continue block40;
                }
                case '\u0099': {
                    buf.append("\u2122");
                    continue block40;
                }
                case '\u009a': {
                    buf.append("\u0161");
                    continue block40;
                }
                case '\u009b': {
                    buf.append("\u203a");
                    continue block40;
                }
                case '\u009c': {
                    buf.append("\u0153");
                    continue block40;
                }
                case '\u009d': {
                    buf.append("\u009d");
                    continue block40;
                }
                case '\u009e': {
                    buf.append("\u017e");
                    continue block40;
                }
                case '\u009f': {
                    buf.append("\u0178");
                    continue block40;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

