/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.cdlib.xtf.cache.Dependency;
import org.cdlib.xtf.util.EmbeddedList;
import org.cdlib.xtf.util.LinkableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cache<K, V> {
    private int maxEntries;
    private int maxTime;
    protected HashMap<K, ListEntry> keyMap;
    protected EmbeddedList ageList;

    public Cache(int maxEntries, int maxTime) {
        this.maxEntries = maxEntries;
        this.maxTime = maxTime;
        this.clear();
    }

    public synchronized boolean has(K key) {
        this.cleanup();
        if (this.keyMap.containsKey(key)) {
            ListEntry entry = this.keyMap.get(key);
            if (this.dependenciesValid(key)) {
                entry.lastUsedTime = System.currentTimeMillis();
                this.ageList.moveToTail(entry);
                this.cleanup();
                return true;
            }
            this.ageList.remove(entry);
            this.keyMap.remove(key);
            this.logAction("Removed (stale dependencies)", key, entry.value);
            this.cleanup();
        }
        return false;
    }

    public synchronized long lastSet(K key) {
        ListEntry ent = this.keyMap.get(key);
        return ent == null ? 0L : ent.setTime;
    }

    public synchronized boolean dependenciesValid(K key) {
        this.cleanup();
        ListEntry ent = this.keyMap.get(key);
        if (ent == null) {
            return false;
        }
        for (Dependency d : ent.dependencies) {
            if (d.validate()) continue;
            return false;
        }
        return true;
    }

    public synchronized Iterator getDependencies(K key) {
        this.cleanup();
        ListEntry ent = this.keyMap.get(key);
        return ent == null ? new NullIterator() : ent.dependencies.iterator();
    }

    public synchronized V remove(K key) {
        this.cleanup();
        if (this.keyMap.containsKey(key)) {
            ListEntry entry = this.keyMap.get(key);
            this.ageList.remove(entry);
            this.keyMap.remove(key);
            this.logAction("Removed", key, entry.value);
            this.cleanup();
            return entry.value;
        }
        return null;
    }

    public synchronized void clear() {
        this.ageList = new EmbeddedList();
        this.keyMap = new HashMap(this.maxEntries);
    }

    public synchronized int size() {
        return this.keyMap.size();
    }

    protected synchronized void cleanup() {
        if (this.maxEntries >= 0) {
            while (this.ageList.getCount() > this.maxEntries) {
                ListEntry ent = (ListEntry)this.ageList.removeHead();
                this.logAction("Expired to maintain max # cache entries... was " + (this.ageList.getCount() + 1) + ", must be <= " + this.maxEntries, ent.key, ent.value);
                this.keyMap.remove(ent.key);
            }
        }
        if (this.maxTime > 0) {
            long maxTimeMillis = this.maxTime * 1000;
            long expireTime = System.currentTimeMillis() - maxTimeMillis;
            while (this.ageList.getCount() > 0 && ((ListEntry)this.ageList.getHead()).lastUsedTime < expireTime) {
                ListEntry ent = (ListEntry)this.ageList.removeHead();
                this.logAction("Expired due to over-age... age is " + (System.currentTimeMillis() - ent.lastUsedTime) / 1000L + " sec, must be < " + this.maxTime + " sec.", ent.key, ent.value);
                this.keyMap.remove(ent.key);
            }
        }
    }

    protected void logAction(String action, K key, V value) {
    }

    protected class ListEntry
    extends LinkableImpl {
        K key;
        V value;
        long lastUsedTime;
        long setTime;
        LinkedList dependencies = new LinkedList();

        protected ListEntry() {
        }
    }

    protected class NullIterator
    implements Iterator {
        protected NullIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

