/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.cache;

import java.io.File;
import org.cdlib.xtf.cache.Dependency;

public class FileDependency
extends Dependency {
    private File file;
    private long lastModified;

    public FileDependency(File file) {
        this.file = file;
        this.lastModified = file.lastModified();
    }

    public FileDependency(String path) {
        this(new File(path));
    }

    public boolean validate() {
        if (this.file.getPath().startsWith("http:")) {
            return true;
        }
        return this.file.canRead() && this.file.lastModified() == this.lastModified;
    }

    public String toString() {
        return "FileDependency(" + this.file.toString() + ":" + this.lastModified;
    }
}

