/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.TreeBuilder;
import org.cdlib.xtf.crossQuery.CrossQueryConfig;
import org.cdlib.xtf.crossQuery.QueryRoute;
import org.cdlib.xtf.servletBase.RedirectException;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryRequestParser;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.util.AttribList;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLFormatter;
import org.cdlib.xtf.util.XMLWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class CrossQuery
extends TextServlet {
    protected CrossQueryConfig config;
    protected static DecimalFormat decimalFormat = new DecimalFormat();

    public String getConfigName() {
        return "conf/crossQuery.conf";
    }

    protected TextConfig readConfig(String configPath) {
        this.config = new CrossQueryConfig(this, configPath);
        return this.config;
    }

    public TextConfig getConfig() {
        return this.config;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            res.setContentType("text/html");
            String stepStr = this.stepSetup(req, res);
            if (stepStr != null) {
                ServletOutputStream out = res.getOutputStream();
                out.println(stepStr);
                out.close();
                return;
            }
            Trace.debug("Processing request: " + CrossQuery.getRequestURL(req));
            this.apply(this.makeAttribList(req), req, res);
        }
        catch (Exception e) {
            if (!(e instanceof RedirectException) && !(e instanceof SocketException)) {
                try {
                    this.genErrorPage(req, res, e);
                }
                catch (RedirectException re) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public String getServletInfo() {
        return "crossQuery search servlet";
    }

    protected void apply(AttribList attribs, HttpServletRequest req, HttpServletResponse res) throws Exception {
        long startTime = System.currentTimeMillis();
        QueryRoute queryRoute = this.runQueryRouter(req, res, attribs);
        if (queryRoute == null) {
            return;
        }
        QueryRequest queryReq = this.runQueryParser(req, res, queryRoute, attribs);
        if (queryReq == null) {
            return;
        }
        QueryProcessor proc = CrossQuery.createQueryProcessor();
        QueryResult queryResult = proc.processRequest(queryReq);
        this.formatHits("crossQueryResult", req, res, attribs, queryReq, queryResult, startTime);
    }

    protected QueryRoute runQueryRouter(HttpServletRequest req, HttpServletResponse res, AttribList attribs) throws Exception {
        String step = req.getParameter("debugStep");
        if (this.config.queryRouterSheet == null) {
            if ("1b".equals(step)) {
                res.setContentType("text/html");
                res.getOutputStream().println("queryRouter stylesheet not specified;<br/> using default route to: " + this.config.queryParserSheet);
                return null;
            }
            return QueryRoute.createDefault(this.config.queryParserSheet);
        }
        XMLFormatter fmt = new XMLFormatter();
        fmt.blankLineAfterTag(false);
        this.buildParamBlock(attribs, fmt, null, null);
        if ("1b".equals(step)) {
            res.setContentType("text/xml");
            res.getOutputStream().println(fmt.toString());
            return null;
        }
        Templates sheet = this.stylesheetCache.find(this.config.queryRouterSheet);
        Transformer trans = sheet.newTransformer();
        CrossQuery.stuffAttribs(trans, this.config.attribs);
        CrossQuery.stuffAttribs(trans, attribs);
        this.stuffSpecialAttribs(req, trans);
        if (Trace.getOutputLevel() >= 8) {
            String tmp = fmt.toString();
            if (tmp.endsWith("\n")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            Trace.debug("*** queryRouter input ***\n" + tmp);
        }
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        TreeBuilder output = new TreeBuilder();
        trans.transform(fmt.toSource(), output);
        NodeInfo queryRouteDoc = output.getCurrentRoot();
        if (Trace.getOutputLevel() >= 8) {
            Trace.debug("*** queryRouter output ***\n" + XMLWriter.toString(queryRouteDoc, false));
        }
        QueryRoute route = QueryRoute.parse(queryRouteDoc);
        route.queryParserSheet = this.getRealPath(route.queryParserSheet);
        if (route.errorGenSheet != null) {
            this.setErrorGenSheet(this.getRealPath(route.errorGenSheet));
        }
        route.routerInput = fmt.toString();
        route.routerOutput = XMLWriter.toString(queryRouteDoc, false);
        return route;
    }

    protected QueryRequest runQueryParser(HttpServletRequest req, HttpServletResponse res, QueryRoute route, AttribList attribs) throws Exception {
        XMLFormatter fmt = new XMLFormatter();
        fmt.blankLineAfterTag(false);
        this.buildParamBlock(attribs, fmt, route.tokenizerMap, route.routerOutput);
        String step = req.getParameter("debugStep");
        if ("2b".equals(step)) {
            res.setContentType("text/xml");
            res.getOutputStream().println(fmt.toString());
            return null;
        }
        Templates genSheet = this.stylesheetCache.find(route.queryParserSheet);
        Transformer trans = genSheet.newTransformer();
        CrossQuery.stuffAttribs(trans, this.config.attribs);
        CrossQuery.stuffAttribs(trans, attribs);
        this.stuffSpecialAttribs(req, trans);
        if (Trace.getOutputLevel() >= 8) {
            String tmp = fmt.toString();
            if (tmp.endsWith("\n")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            Trace.debug("*** queryParser input ***\n" + tmp);
        }
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        TreeBuilder output = new TreeBuilder();
        trans.transform(fmt.toSource(), output);
        NodeInfo queryReqDoc = output.getCurrentRoot();
        if (Trace.getOutputLevel() >= 8) {
            Trace.debug("*** queryParser output ***\n" + XMLWriter.toString(queryReqDoc, false));
        }
        if (this.shuntQueryReq(req, res, queryReqDoc)) {
            return null;
        }
        QueryRequest queryReq = new QueryRequestParser().parseRequest(queryReqDoc, new File(this.getRealPath("")));
        queryReq.parserInput = fmt.toString();
        queryReq.parserOutput = XMLWriter.toString(queryReqDoc, false);
        return queryReq;
    }

    protected boolean shuntQueryReq(HttpServletRequest req, HttpServletResponse res, Source queryReqDoc) throws IOException {
        String step = req.getParameter("debugStep");
        if ("3b".equals(step)) {
            res.setContentType("text/xml");
            res.getOutputStream().println(XMLWriter.toString(queryReqDoc));
            return true;
        }
        return false;
    }

    protected void formatHits(String mainTagName, HttpServletRequest req, HttpServletResponse res, AttribList attribs, QueryRequest queryRequest, QueryResult queryResult, long startTime) throws Exception {
        Transformer trans;
        String raw = req.getParameter("raw");
        if (raw == null) {
            raw = (String)req.getAttribute("org.cdlib.xtf.servlet.raw");
        }
        String step = req.getParameter("debugStep");
        if ("yes".equals(raw) || "true".equals(raw) || "1".equals(raw) || "4b".equals(step)) {
            res.setContentType("text/xml");
            trans = IndexUtil.createTransformer();
            Properties props = trans.getOutputProperties();
            props.put("indent", "yes");
            props.put("method", "xml");
            trans.setOutputProperties(props);
        } else {
            Templates displaySheet = this.stylesheetCache.find(queryRequest.displayStyle);
            res.setContentType(CrossQuery.calcMimeType(displaySheet));
            trans = displaySheet.newTransformer();
        }
        CrossQuery.stuffAttribs(trans, this.config.attribs);
        CrossQuery.stuffAttribs(trans, attribs);
        this.stuffSpecialAttribs(req, trans);
        StringBuffer extraStuff = new StringBuffer();
        if (queryRequest.parserInput != null) {
            extraStuff.append(queryRequest.parserInput);
        }
        if (queryRequest.parserOutput != null) {
            extraStuff.append(queryRequest.parserOutput);
        }
        String hitsString = queryResult.hitsToString(mainTagName, extraStuff.toString());
        String prefix = "<" + mainTagName + " ";
        assert (hitsString.startsWith(prefix));
        long queryTime = System.currentTimeMillis() - startTime;
        String formattedTime = decimalFormat.format((double)queryTime / 1000.0);
        hitsString = prefix + "queryTime=\"" + formattedTime + "\" " + hitsString.substring(prefix.length());
        StreamSource sourceDoc = new StreamSource(new StringReader(hitsString));
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        trans.transform(sourceDoc, this.createFilteredReceiver(trans, req, res));
    }

    protected String stepSetup(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String baseUrl = req.getRequestURL().toString();
        if (baseUrl.indexOf(63) < 0 && req.getQueryString() != null && req.getQueryString().length() > 0) {
            baseUrl = baseUrl + "?" + req.getQueryString();
        }
        baseUrl = baseUrl.replaceAll("\"", "&quot;");
        String step = req.getParameter("debugStep");
        if (step == null || step.length() == 0) {
            return null;
        }
        if (step.matches("^[0-9]$")) {
            String urlA = baseUrl.replaceAll("debugStep=" + step, "debugStep=" + step + "a");
            String urlB = baseUrl.replaceAll("debugStep=" + step, "debugStep=" + step + "b");
            return "<html>\n  <head>\n    <title>crossQuery Step " + step + "</title>\n" + "  </head>\n" + "  <frameset rows=\"195,*\" border=\"2\" framespacing=\"2\" " + "frameborder=\"1\">\n" + "    <frame title=\"Info\" name=\"info\" src=\"" + urlA + "\">\n" + "    <frame title=\"Data\" name=\"data\" src=\"" + urlB + "\">\n" + "  </frameset>\n" + "</html>";
        }
        if (step.matches("^[0-9]a$")) {
            String nextUrl;
            int stepNum = Integer.parseInt(step.substring(0, 1));
            StringBuffer out = new StringBuffer();
            out.append("<html>\n  <body>\n    <b><i>crossQuery</b></i> Step " + stepNum + " &nbsp;&nbsp; ");
            String prevUrl = stepNum == 1 ? null : baseUrl.replaceAll("debugStep=" + step, "debugStep=" + (stepNum - 1));
            String string = nextUrl = stepNum == 5 ? null : baseUrl.replaceAll("debugStep=" + step, "debugStep=" + (stepNum + 1));
            if (stepNum > 1) {
                out.append("<a href=\"" + prevUrl + "\" target=\"_top\">[Previous]</a> ");
            } else {
                out.append("<font color=\"#C0C0C0\">[Previous]</font> ");
            }
            if (stepNum < 5) {
                out.append("<a href=\"" + nextUrl + "\" target=\"_top\">[Next]</a>");
            } else {
                out.append("<font color=\"#C0C0C0\">[Next]</font>");
            }
            out.append("    <table cellspacing=\"5\" cellpadding=\"0\">\n      <tr>\n");
            for (int i = 1; i <= 5; ++i) {
                if (i == stepNum) {
                    out.append("<td bgcolor=\"#E0E0E0\"><b>");
                } else {
                    out.append("<td>");
                }
                if (i != stepNum) {
                    String link = baseUrl.replaceAll("debugStep=" + step, "debugStep=" + i);
                    out.append("<a href=\"" + link + "\" target=\"_top\">");
                }
                out.append("Step " + i + "<br>");
                if (i != stepNum) {
                    out.append("</a>");
                }
                switch (i) {
                    case 1: {
                        out.append("Raw URL parameters");
                        break;
                    }
                    case 2: {
                        out.append("Tokenized URL parameters");
                        break;
                    }
                    case 3: {
                        out.append("XML query");
                        break;
                    }
                    case 4: {
                        out.append("Raw results");
                        break;
                    }
                    case 5: {
                        out.append("Formatted results");
                    }
                }
                out.append("</td>");
                if (i < 5) {
                    out.append("<td>--></td><td>");
                    switch (i) {
                        case 1: {
                            out.append("Query Router");
                            break;
                        }
                        case 2: {
                            out.append("Query Parser");
                            break;
                        }
                        case 3: {
                            out.append("Text Engine");
                            break;
                        }
                        case 4: {
                            out.append("Result Formatter");
                        }
                    }
                    out.append("</td><td>--></td>");
                }
                if (i == stepNum) {
                    out.append("</b>");
                }
                out.append("</td>\n");
            }
            out.append("      </tr>\n    </table>\n");
            switch (stepNum) {
                case 1: {
                    if (this.config.queryRouterSheet == null) {
                        out.append("Step 1 is the raw URL parameters to be fed to the <b>Query Router</b> stylesheet. Since no query router was specified, the request will be routed automatically to <code><b>" + this.config.queryParserSheet + "</b></code>. Skip to " + "<a href=\"" + nextUrl + "\" target=\"_top\">step 2</a>.");
                        break;
                    }
                    out.append("In step 1, parameters specified in the URL are translated, without tokenizing, to an XML <code>&lt;parameters&gt;</code> block (shown below). Next, this will be fed to the <b>Query Router</b> stylesheet, <code><b>" + this.config.queryRouterSheet + "</b></code>. The result " + "should be the route to a query parser stylesheet in " + "<a href=\"" + nextUrl + "\" target=\"_top\">step 2</a>.");
                    break;
                }
                case 2: {
                    out.append("In step 2, parameters specified in the URL are tokenized and translated to an XML <code>&lt;parameters&gt;</code> block (shown below). Next, this will be fed to the <b>Query Parser</b> stylesheet. The result should be an XML query in <a href=\"" + nextUrl + "\" target=\"_top\">step 3</a>.");
                    break;
                }
                case 3: {
                    out.append("Step 3: The URL parameters from <a href=\"" + prevUrl + "\" target=\"_top\">step 2</a> " + "have now been processed by the <b>Query Parser</b> stylesheet " + "into an XML query, shown below. Next, XTF's <b>Text Engine</b> " + "will execute this query to produce the raw search " + "results in " + "<a href=\"" + nextUrl + "\" target=\"_top\">step 4</a>. " + "Note that the final <b>Result Formatter</b> stylesheet " + "(for step 5) is specified here as well.");
                    break;
                }
                case 4: {
                    out.append("In step 4, XTF's <b>Text Engine</b> has executed the XML query from <a href=\"" + prevUrl + "\" target=\"_top\">step 3</a> " + "to produce raw search results, shown below. These will be " + "fed in turn to the <b>Result Formatter</b> stylesheet " + "to produce the final HTML page in " + "<a href=\"" + nextUrl + "\" target=\"_top\">step 5</a>.");
                    break;
                }
                case 5: {
                    out.append("Step 5 shows the final HTML result produced by feeding the raw search results from <a href=\"" + prevUrl + "\" target=\"_top\">step 4</a> " + "into the <b>Result Formatter</b> stylesheet.");
                }
            }
            out.append("  </body>\n</html>");
            return out.toString();
        }
        return null;
    }
}

