/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery;

import org.cdlib.xtf.crossQuery.CrossQuery;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.util.GeneralException;

public class CrossQueryConfig
extends TextConfig {
    public String queryRouterSheet;
    public String queryParserSheet;

    public CrossQueryConfig(CrossQuery servlet) {
        super(servlet);
    }

    public CrossQueryConfig(CrossQuery servlet, String path) throws GeneralException {
        super(servlet);
        super.read("crossQuery-config", path);
        if (!(this.queryRouterSheet != null && this.queryRouterSheet.length() != 0 || this.queryParserSheet != null && this.queryParserSheet.length() != 0)) {
            CrossQueryConfig.requireOrElse(this.queryRouterSheet, "Config file error: queryRouter path not specified");
        }
    }

    public boolean handleProperty(String tagAttr, String strVal) {
        if (tagAttr.equalsIgnoreCase("queryRouter.path")) {
            this.queryRouterSheet = this.servlet.getRealPath(strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("queryParser.path")) {
            this.queryParserSheet = this.servlet.getRealPath(strVal);
            return true;
        }
        return super.handleProperty(tagAttr, strVal);
    }
}

