/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

class IpList {
    private ArrayList<IpRange> ranges = new ArrayList();

    public IpList(String path) throws IOException {
        this.readRanges(path);
    }

    public boolean isApproved(String ipAddrStr) {
        IpAddr parsedAddr = new IpAddr();
        if (parsedAddr.parse(ipAddrStr) == null) {
            return false;
        }
        boolean positive = false;
        boolean negative = false;
        for (IpRange range : this.ranges) {
            if (!range.matches(parsedAddr)) continue;
            if (range.isPositive) {
                positive = true;
                continue;
            }
            negative = true;
        }
        if (negative) {
            return false;
        }
        return positive;
    }

    private void readRanges(String path) throws IOException {
        String line;
        InputStreamReader rawReader;
        if (path.startsWith("http://")) {
            URLConnection conn = new URL(path).openConnection();
            conn.setAllowUserInteraction(false);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setUseCaches(false);
            conn.connect();
            rawReader = new InputStreamReader(conn.getInputStream());
        } else {
            rawReader = new FileReader(path);
        }
        LineNumberReader reader = new LineNumberReader(rawReader);
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            if (Character.isDigit(line.charAt(0)) || line.charAt(0) == '*') {
                this.processEntry(line, true);
                continue;
            }
            if (!line.startsWith("exclude")) continue;
            line = line.substring(7).trim();
            this.processEntry(line, false);
        }
    }

    private void processEntry(String line, boolean isPositive) {
        IpAddr startIp = new IpAddr();
        IpAddr endIp = new IpAddr();
        String str = line;
        if ((str = startIp.parse(str)) == null) {
            return;
        }
        if ((str = str.trim()).startsWith("-")) {
            str = str.substring(1).trim();
            if ((str = endIp.parse(str)) == null) {
                return;
            }
        } else {
            endIp = startIp;
        }
        IpRange range = new IpRange(startIp, endIp, isPositive);
        this.ranges.add(range);
    }

    private class IpRange {
        public IpAddr startAddr;
        public IpAddr endAddr;
        public boolean isPositive;

        IpRange(IpAddr _start, IpAddr _end, boolean _isPos) {
            this.startAddr = _start;
            this.endAddr = _end;
            this.isPositive = _isPos;
        }

        boolean matches(IpAddr addr) {
            int ic;
            int i;
            for (i = 0; i < 4; ++i) {
                ic = addr.components[i];
                int sc = this.startAddr.components[i];
                if (sc == 999) {
                    sc = 0;
                }
                if (ic < sc) {
                    return false;
                }
                if (ic > sc) break;
            }
            for (i = 0; i < 4; ++i) {
                ic = addr.components[i];
                int ec = this.endAddr.components[i];
                if (ec == 999) {
                    ec = 255;
                }
                if (ic > ec) {
                    return false;
                }
                if (ic < ec) break;
            }
            return true;
        }
    }

    private class IpAddr {
        public int[] components = new int[4];

        IpAddr() {
        }

        IpAddr(int c0, int c1, int c2, int c3) {
            this.components[0] = c0;
            this.components[1] = c1;
            this.components[2] = c2;
            this.components[3] = c3;
        }

        boolean componentsEqual(IpAddr other, int nComps) {
            for (int i = 0; i < nComps; ++i) {
                if (this.components[i] == other.components[i]) continue;
                return false;
            }
            return true;
        }

        String parse(String str) {
            int pos = 0;
            for (int compNum = 0; compNum < 4; ++compNum) {
                char c;
                if (pos >= str.length()) {
                    return null;
                }
                if ((c = str.charAt(pos++)) == '*') {
                    this.components[compNum] = 999;
                } else if (Character.isDigit(c)) {
                    StringBuffer numStr = new StringBuffer();
                    numStr.append(c);
                    while (pos < str.length() && Character.isDigit(c = str.charAt(pos))) {
                        numStr.append(c);
                        ++pos;
                    }
                    int num = Integer.parseInt(numStr.toString());
                    if (num > 255) {
                        return null;
                    }
                    this.components[compNum] = num;
                } else {
                    return null;
                }
                if (compNum >= 3) continue;
                if (pos >= str.length()) {
                    return null;
                }
                if ((c = str.charAt(pos++)) == '.') continue;
                return null;
            }
            return str.substring(pos);
        }
    }
}

