/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML.test;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.cdlib.xtf.dynaXML.test.SearchTest;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class CDLSearchTest
extends SearchTest {
    private static final String server = "http://foo.bar/";
    private static final String urlPrefix = "http://foo.bar/dynaXML";
    private int totalUrls = 0;
    private int urlsDone = 0;
    private final String searchTerm = "those";
    private String skipToDoc = null;
    private boolean skipping = true;
    private String debugDoc = null;
    private int debugNum = -1;

    public CDLSearchTest(String baseDir) throws ServletException {
        super(baseDir);
    }

    private String docIdFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        assert (lastSlash >= 0);
        int dotXml = path.lastIndexOf(".xml");
        assert (dotXml >= 0);
        return path.substring(lastSlash + 1, dotXml);
    }

    private String[] getDocs(String indexPath, String sourcePath) throws IOException {
        IndexReader reader = IndexReader.open(indexPath);
        Term term = new Term("docInfo", "1");
        int nDocs = reader.docFreq(term);
        String[] docPaths = new String[nDocs];
        TermDocs docHeaders = reader.termDocs(term);
        int i = 0;
        while (docHeaders.next()) {
            int docNum = docHeaders.doc();
            Document doc = reader.document(docNum);
            String key = doc.get("key");
            assert (key != null && key.length() > 0) : "missing key in DocInfo";
            String partPath = key.substring(key.indexOf(58) + 1);
            docPaths[i++] = Path.normalizeFileName(sourcePath + "/" + partPath);
        }
        if (i != docPaths.length) {
            String[] newArray = new String[i];
            System.arraycopy(docPaths, 0, newArray, 0, i);
            docPaths = newArray;
        }
        return docPaths;
    }

    private void pushUrl(HashSet processedUrls, String url, LinkedList urlStack) {
        String view;
        if (!url.startsWith("http")) {
            url = server + url;
        }
        if (!url.startsWith(urlPrefix)) {
            return;
        }
        url = url.replaceAll("&amp;", "&");
        url = url.replaceAll("&&", "&");
        url = url.replaceAll("#.*", "");
        url = url.replaceAll("&anchor.id=[^&#]+", "");
        url = url.replaceAll("&set.anchor=[^&#]+", "");
        url = url.replaceAll("&toc.id=0", "");
        url = url.replaceAll("&toc.id=&", "&");
        url = url.replaceAll("&toc.depth=0", "");
        url = url.replaceAll("&toc.depth=&", "&");
        url = url.replaceAll("&chunk.id=0", "");
        url = url.replaceAll("&chunk.id=&", "&");
        url = url.replaceAll("&query=[^&#]*", "");
        url = url + "&query=those";
        Matcher matcher = Pattern.compile("&doc.view=([^&#]*)").matcher(url);
        String string = view = matcher.find() ? matcher.group(1) : "";
        if ("bbar|toc|".indexOf(view + "|") >= 0) {
            url = url.replaceAll("&chunk.id=[^&#]*", "");
        }
        if ("bbar|content|".indexOf(view + "|") >= 0) {
            url = url.replaceAll("&toc.id=[^&#]*", "");
            url = url.replaceAll("&toc.depth=[^&#]*", "");
        }
        if (!processedUrls.contains(url)) {
            urlStack.addLast(url);
            processedUrls.add(url);
            ++this.totalUrls;
        }
    }

    private void pushUrls(HashSet processedUrls, String htmlResult, LinkedList urlStack) {
        Matcher matcher = Pattern.compile("<a\\s+href=\"([^\"]*)\"").matcher(htmlResult);
        while (matcher.find()) {
            this.pushUrl(processedUrls, matcher.group(1), urlStack);
        }
        matcher = Pattern.compile("<frame\\s+[^>]*src=\"([^\"]*)\"").matcher(htmlResult);
        while (matcher.find()) {
            this.pushUrl(processedUrls, matcher.group(1), urlStack);
        }
    }

    private String normalizeResult(String result) {
        result = result.replaceAll(" xmlns:\\w+=\"[^\"]+\"", "");
        return result;
    }

    String[] slurp(String str) {
        BufferedReader br = new BufferedReader(new StringReader(str));
        Vector<String> lines = new Vector<String>(100);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            assert (false) : "String reader should never have IO exception";
            throw new RuntimeException(e);
        }
        return lines.toArray(new String[lines.size()]);
    }

    private boolean sameResults(String result1, String result2) {
        if (result1.equals(result2)) {
            return true;
        }
        Trace.info("\n*** Mismatch! ***");
        return false;
    }

    private void testDoc(String docPath) throws Exception {
        if (this.debugDoc != null && !this.docIdFromPath(docPath).endsWith(this.debugDoc)) {
            Trace.info("Skipping " + this.docIdFromPath(docPath));
            return;
        }
        if (this.skipToDoc != null && this.skipping) {
            if (this.docIdFromPath(docPath).endsWith(this.skipToDoc)) {
                this.skipping = false;
            }
            if (this.skipping) {
                Trace.info("Skipping " + this.docIdFromPath(docPath));
                return;
            }
        }
        Trace.info("Processing " + this.docIdFromPath(docPath) + "...");
        this.dynaXML.setSearchTerm("those");
        LinkedList<String> urlStack = new LinkedList<String>();
        urlStack.addLast("http://foo.bar/dynaXML?docId=" + this.docIdFromPath(docPath) + "&doc.view=frames" + "&query=" + "those");
        this.totalUrls = 1;
        this.urlsDone = 0;
        HashSet<String> processedUrls = new HashSet<String>();
        int nMismatches = 0;
        while (!urlStack.isEmpty()) {
            String url = (String)urlStack.removeFirst();
            processedUrls.add(url);
            ++this.urlsDone;
            Trace.info("  " + this.urlsDone + "/" + this.totalUrls + ": " + url.substring(urlPrefix.length() + 1) + "...");
            if (this.urlsDone == this.debugNum) {
                this.dynaXML.setProfiling(true);
                this.dynaXML.setDump(true);
            }
            long start1 = System.currentTimeMillis();
            this.dynaXML.useAnnotated(true);
            String result1 = this.runDynaXML(url);
            result1 = this.normalizeResult(result1);
            long start2 = System.currentTimeMillis();
            this.dynaXML.useAnnotated(false);
            String result2 = this.runDynaXML(url);
            result2 = this.normalizeResult(result2);
            long end2 = System.currentTimeMillis();
            long elapsed = end2 - start1;
            long rate = (long)result2.length() / (elapsed + 1L);
            long rate1 = (long)result1.length() / (start2 - start1 + 1L);
            long rate2 = (long)result2.length() / (end2 - start2 + 1L);
            Trace.info(" (time=" + (start2 - start1) + "/" + (end2 - start2) + ", bytes=" + result1.length() + ", rate=" + rate1 + "/" + rate2 + ")");
            if (!this.sameResults(result1, result2)) {
                Trace.info("Mismatch: " + url);
                ++nMismatches;
                System.exit(1);
            }
            if (this.urlsDone == this.debugNum) {
                PrintWriter outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("C:\\tmp\\out1.html"), "UTF-8"));
                outWriter.println(result1);
                outWriter.close();
                outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("C:\\tmp\\out2.html"), "UTF-8"));
                outWriter.println(result2);
                outWriter.close();
                System.exit(0);
            }
            this.pushUrls(processedUrls, result1, urlStack);
        }
    }

    public void runTest(String indexPath, String sourcePath) throws Exception {
        Trace.info("Getting docs...");
        String[] docPaths = this.getDocs(indexPath, sourcePath);
        Trace.info("Got docs.");
        for (int i = 0; i < docPaths.length; ++i) {
            this.testDoc(docPaths[i]);
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            Trace.error("Usage: CDLSearchTest [baseDir] [indexPath] [sourcePath] {start-doc-id}");
            System.exit(1);
        }
        boolean flag = false;
        if (!$assertionsDisabled) {
            flag = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!flag) {
            Trace.error("Assertions must be enabled for this test. Pass -ea to Jave VM.");
            System.exit(1);
        }
        try {
            CDLSearchTest test = new CDLSearchTest(args[0]);
            if (args.length > 3) {
                test.skipToDoc = args[3];
            }
            test.runTest(args[1], args[2]);
        }
        catch (Exception e) {
            Trace.error("Fatal exception: " + e);
            System.exit(1);
        }
        System.exit(0);
    }
}

