/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.tree.TreeBuilder;
import org.cdlib.xtf.dynaXML.DocRequest;
import org.cdlib.xtf.dynaXML.DynaXML;
import org.cdlib.xtf.dynaXML.InvalidDocumentException;
import org.cdlib.xtf.dynaXML.test.TreeAnnotater;
import org.cdlib.xtf.lazyTree.LazyKeyManager;
import org.cdlib.xtf.util.DocTypeDeclRemover;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestableDynaXML
extends DynaXML {
    private boolean useAnnotated = false;
    private boolean dump = false;
    private String prevAnnotatedPath;
    private DocumentInfo prevAnnotatedTree;
    private String searchTerm;

    public void useAnnotated(boolean flag) {
        this.useAnnotated = flag;
    }

    public void setSearchTerm(String term) {
        this.searchTerm = term;
    }

    public DocumentInfo getAnnotatedTree(String sourcePath) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if ((sourcePath = sourcePath.replaceAll("\\\\", "/")).equals(this.prevAnnotatedPath)) {
            return this.prevAnnotatedTree;
        }
        assert (this.searchTerm != null);
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fac.newDocumentBuilder();
        InputStream inStream = new FileInputStream(new File(sourcePath));
        inStream = new DocTypeDeclRemover(inStream);
        Document doc = builder.parse(inStream);
        TreeAnnotater annotater = new TreeAnnotater();
        annotater.processDocument(doc, this.searchTerm);
        Configuration config = new Configuration();
        DOMSource src = new DOMSource(doc);
        config.setErrorListener(new XTFSaxonErrorListener());
        this.prevAnnotatedTree = (DocumentInfo)TreeBuilder.build((Source)src, (Stripper)new AllElementStripper(), config);
        this.prevAnnotatedPath = sourcePath;
        return this.prevAnnotatedTree;
    }

    public static void dumpTree(String fileName, Source tree) {
        try {
            File file = new File(fileName);
            Trace.info("Dumping " + file.getAbsolutePath());
            PrintWriter outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            String str = XMLWriter.toString(tree);
            str = str.replaceAll(" score=\"\\w+\"", "");
            str = str.replaceAll(" rank=\"\\w+\"", "");
            str = str.replaceAll(" more=\"\\w+\"", "");
            str = str.replaceAll(" xmlns:xtf=\"http://cdlib.org/xtf\"", "");
            outWriter.println(str);
            outWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDump(boolean flag) {
        this.dump = flag;
    }

    protected Source getSourceDoc(DocRequest docReq, Transformer transformer) throws IOException, SAXException, ParserConfigurationException {
        forceLazy = true;
        if (!this.useAnnotated) {
            Source realSrc = super.getSourceDoc(docReq, transformer);
            if (this.dump) {
                TestableDynaXML.dumpTree("C:\\tmp\\tree.dump", realSrc);
            }
            return realSrc;
        }
        Controller c = (Controller)transformer;
        Executable e = c.getExecutable();
        KeyManager k = e.getKeyManager();
        if (k instanceof LazyKeyManager) {
            e.setKeyManager(new KeyManager(c.getConfiguration()));
        }
        e.setStripsWhitespace(false);
        try {
            DocumentInfo src = this.getAnnotatedTree(docReq.source);
            if (this.dump) {
                TestableDynaXML.dumpTree("C:\\tmp\\annotated.dump", src);
            }
            return src;
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean authenticate(DocRequest docReq, HttpServletRequest req, HttpServletResponse res) throws Exception {
        return true;
    }

    protected void genErrorPage(HttpServletRequest req, HttpServletResponse res, Exception exc) {
        if (exc instanceof InvalidDocumentException) {
            Trace.error("Invalid document. ");
            return;
        }
        if (exc.getClass().getName().indexOf("QueryFormatError") >= 0) {
            Trace.error("Query format error.");
            return;
        }
        Trace.error("Exception occurred in dynaXML: " + exc);
        Trace.error("");
        exc.printStackTrace(System.out);
        throw new RuntimeException(exc);
    }
}

