/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML.test;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TreeAnnotater {
    private StandardAnalyzer analyzer = new StandardAnalyzer();
    private String searchTerm;
    private Document doc;
    private static final String xtfUri = "http://cdlib.org/xtf";
    private int totalHitCount = 0;

    public void processDocument(Document doc, String term) {
        this.doc = doc;
        this.searchTerm = term;
        int nHits = this.processElement(doc.getDocumentElement(), 0);
        assert (this.totalHitCount == nHits);
    }

    private boolean isAllWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int processElement(Element parent, int level) {
        int firstHit = this.totalHitCount;
        int nHits = 0;
        Node child = parent.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            if (child instanceof Text) {
                if (this.isAllWhitespace(((Text)child).getData())) {
                    parent.removeChild(child);
                } else {
                    nHits += this.processText((Text)child);
                }
            } else if (child instanceof Element && !child.getNodeName().equals("xtf:hit")) {
                nHits += this.processElement((Element)child, level + 1);
            }
            child = next;
        }
        if (nHits > 0 || level < 1) {
            Attr attr = this.doc.createAttributeNS(xtfUri, "xtf:hitCount");
            attr.setValue(Integer.toString(nHits));
            parent.setAttributeNode(attr);
            attr = this.doc.createAttributeNS(xtfUri, "xtf:firstHit");
            attr.setValue(Integer.toString(firstHit + 1));
            parent.setAttributeNode(attr);
        }
        return nHits;
    }

    private int processText(Text node) {
        int hitCount = 0;
        while (true) {
            Token t;
            String text = node.getData();
            TokenStream tokens = this.analyzer.tokenStream("text", new StringReader(text));
            do {
                try {
                    t = tokens.next();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } while (t != null && !t.termText().equals(this.searchTerm));
            if (t == null) break;
            node.setData(text.substring(0, t.startOffset()));
            Element hitEl = this.doc.createElementNS(xtfUri, "xtf:hit");
            ++this.totalHitCount;
            hitEl.setAttribute("hitNum", Integer.toString(this.totalHitCount));
            node.getParentNode().insertBefore(hitEl, node.getNextSibling());
            Element termEl = this.doc.createElementNS(xtfUri, "xtf:term");
            hitEl.appendChild(termEl);
            Text termText = this.doc.createTextNode(text.substring(t.startOffset(), t.endOffset()));
            termEl.appendChild(termText);
            ++hitCount;
            Text nextText = this.doc.createTextNode(text.substring(t.endOffset(), text.length()));
            node.getParentNode().insertBefore(nextText, hitEl.getNextSibling());
            node = nextText;
        }
        return hitCount;
    }
}

