/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import org.cdlib.xtf.lazyTree.AttributeImpl;
import org.cdlib.xtf.lazyTree.ElementImpl;
import org.cdlib.xtf.lazyTree.NodeImpl;

final class AttributeEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private ElementImpl element;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public AttributeEnumeration(NodeImpl node, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (node.getNodeKind() == 1) {
            this.element = (ElementImpl)node;
            if (this.element.attrNames == null) {
                return;
            }
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                int fingerprint = test.getFingerprint();
                for (int i = 0; i < this.element.attrNames.length; ++i) {
                    if ((this.element.attrNames[i] & 0xFFFFF) != fingerprint) continue;
                    this.next = new AttributeImpl(this.element, i);
                    return;
                }
                this.next = null;
            } else {
                this.length = this.element.attrNames.length;
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() {
        if (this.next == null) {
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            if (this.index < this.length) {
                this.next = new AttributeImpl(this.element, this.index);
                ++this.index;
                continue;
            }
            this.next = null;
            return;
        } while (!this.nodeTest.matches(this.next.getNodeKind(), this.next.getFingerprint(), this.next.getTypeAnnotation()));
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.element, this.nodeTest);
    }

    public int getProperties() {
        return 4;
    }
}

