/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeListIterator;
import net.sf.saxon.om.StrippedNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.SystemIdMap;
import org.cdlib.xtf.lazyTree.ElementImpl;
import org.cdlib.xtf.lazyTree.NodeImpl;
import org.cdlib.xtf.lazyTree.ParentNodeImpl;
import org.cdlib.xtf.lazyTree.PersistentTree;
import org.cdlib.xtf.lazyTree.ProfilingListener;
import org.cdlib.xtf.lazyTree.TextImpl;
import org.cdlib.xtf.util.DiskHashReader;
import org.cdlib.xtf.util.DiskHashWriter;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreReader;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.ThreadWatcher;
import org.cdlib.xtf.util.Trace;

public class LazyDocument
extends ParentNodeImpl
implements DocumentInfo,
PersistentTree {
    protected Configuration config;
    protected NamePool namePool;
    protected int documentNumber;
    protected boolean usesNamespaces = false;
    protected int rootNodeNum = 0;
    protected boolean debug = false;
    protected StructuredStore mainStore;
    protected SubStoreReader textFile;
    protected SubStoreReader nodeFile;
    protected int numberOfNodes;
    protected static final int NODE_FILE_HEADER_SIZE = 12;
    protected int maxNodeSize;
    protected byte[] nodeBytes;
    protected PackedByteBuf nodeBuf;
    protected SubStoreReader attrFile;
    protected int maxAttrSize;
    protected byte[] attrBytes;
    protected PackedByteBuf attrBuf;
    public int numberOfNamespaces = 0;
    public int[] namespaceParent;
    public int[] namespaceCode;
    public SystemIdMap systemIdMap = null;
    int[] nameNumToCode;
    HashMap nodeCache = new HashMap();
    boolean allPermanent = false;
    private ProfilingListener profileListener;
    private int killCheckCounter = 0;

    public LazyDocument(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
        if (config.getTraceListener() instanceof ProfilingListener) {
            this.profileListener = (ProfilingListener)config.getTraceListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(NamePool pool, StructuredStore store) throws IOException {
        this.mainStore = store;
        this.nodeNum = 0;
        this.parentNum = -1;
        this.document = this;
        this.namePool = pool;
        StructuredStore structuredStore = this.mainStore;
        synchronized (structuredStore) {
            this.readNames(store.openSubStore("names"));
            this.nodeFile = store.openSubStore("nodes");
            this.rootNodeNum = this.nodeFile.readInt();
            this.numberOfNodes = this.nodeFile.readInt();
            this.maxNodeSize = this.nodeFile.readInt();
            this.attrFile = store.openSubStore("attributes");
            this.maxAttrSize = this.attrFile.readInt();
            this.textFile = store.openSubStore("text");
            this.nodeBytes = new byte[this.maxNodeSize];
            this.nodeBuf = new PackedByteBuf(0);
            this.attrBytes = new byte[this.maxAttrSize];
            this.attrBuf = new PackedByteBuf(0);
            this.nodeNum = this.rootNodeNum;
            this.rootNodeNum = -1;
            this.getNode(this.nodeNum);
            this.rootNodeNum = this.nodeNum;
        }
    }

    public void setAllPermanent(boolean flag) {
        this.allPermanent = flag;
        if (this.allPermanent) {
            this.nodeCache.put(0, this);
        }
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void printProfile() throws IOException {
        if (this.profileListener != null) {
            this.profileListener.printProfile();
        }
    }

    public void close() {
        try {
            this.textFile.close();
            this.nodeFile.close();
            this.attrFile.close();
            this.mainStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readNames(SubStoreReader in) throws IOException {
        byte[] data = new byte[(int)in.length()];
        in.read(data);
        PackedByteBuf buf = new PackedByteBuf(data);
        this.numberOfNamespaces = buf.readInt();
        this.namespaceParent = new int[this.numberOfNamespaces];
        this.namespaceCode = new int[this.numberOfNamespaces];
        for (int i = 0; i < this.numberOfNamespaces; ++i) {
            String prefix = buf.readString();
            String uri = buf.readString();
            this.namespaceCode[i] = this.namePool.allocateNamespaceCode(prefix, uri);
            this.namespaceParent[i] = buf.readInt();
        }
        int nNamecodes = buf.readInt();
        this.nameNumToCode = new int[nNamecodes];
        for (int i = 0; i < nNamecodes; ++i) {
            String prefix = buf.readString();
            String uri = buf.readString();
            String localName = buf.readString();
            this.nameNumToCode[i] = this.namePool.allocate(prefix, uri, localName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIndex(String indexName, Map index) throws IOException {
        DiskHashWriter writer = new DiskHashWriter();
        PackedByteBuf buf = new PackedByteBuf(100);
        for (String key : index.keySet()) {
            ArrayList list = (ArrayList)index.get(key);
            buf.reset();
            buf.writeInt(list.size());
            int currentNum = 0;
            for (int i = 0; i < list.size(); ++i) {
                int nodeNum;
                Item node = (Item)list.get(i);
                if (node instanceof NodeImpl) {
                    nodeNum = ((NodeImpl)node).nodeNum;
                } else if (node instanceof StrippedNode) {
                    nodeNum = ((NodeImpl)((StrippedNode)node).getUnderlyingNode()).nodeNum;
                } else {
                    assert (false) : "Cannot get node number";
                    nodeNum = 1;
                }
                buf.writeInt(nodeNum - currentNum);
                currentNum = nodeNum;
            }
            writer.put(key, buf);
        }
        StructuredStore structuredStore = this.mainStore;
        synchronized (structuredStore) {
            writer.outputTo(this.mainStore.createSubStore(indexName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskHashReader getIndex(String indexName) {
        try {
            StructuredStore structuredStore = this.mainStore;
            synchronized (structuredStore) {
                SubStoreReader indexFile = this.mainStore.openSubStore(indexName);
                return new DiskHashReader(indexFile);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void setRootNode(NodeInfo root) {
        this.rootNodeNum = ((NodeImpl)root).nodeNum;
    }

    protected void setElementAnnotation(int nodeNum, int typeCode) {
        assert (false) : "LazyTree doesn't support element annotations yet";
    }

    protected int getTypeAnnotation(int nodeNum) {
        return -1;
    }

    public int getNodeKind() {
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeImpl getNode(int num) {
        NodeImpl node = this.checkCache(num);
        if (node != null) {
            return node;
        }
        try {
            if (num >= this.numberOfNodes || num < 0) {
                assert (num == -1);
                return null;
            }
            if (num == this.rootNodeNum) {
                return this;
            }
            if (this.profileListener != null) {
                this.profileListener.bumpCount(num);
            }
            StructuredStore structuredStore = this.mainStore;
            synchronized (structuredStore) {
                this.nodeFile.seek(12 + num * this.maxNodeSize);
                this.nodeFile.read(this.nodeBytes);
            }
            this.nodeBuf.setBytes(this.nodeBytes);
            short kind = this.nodeBuf.readByte();
            int flags = this.nodeBuf.readInt();
            switch (kind) {
                case 9: {
                    node = this;
                    break;
                }
                case 1: {
                    node = this.createElementNode();
                    break;
                }
                case 3: {
                    node = this.createTextNode();
                    break;
                }
                case 8: {
                    assert (false) : "comments not yet supported";
                    break;
                }
                case 7: {
                    assert (false) : "processing instructions not yet supported";
                    break;
                }
                default: {
                    assert (false) : "Invalid node kind";
                    return null;
                }
            }
            node.nodeNum = num;
            node.document = this;
            if ((flags & 1) != 0) {
                int nameIdx = this.nodeBuf.readInt();
                node.nameCode = this.nameNumToCode[nameIdx];
            } else {
                node.nameCode = -1;
            }
            node.parentNum = (flags & 2) != 0 ? this.nodeBuf.readInt() : -1;
            node.prevSibNum = (flags & 4) != 0 ? this.nodeBuf.readInt() : -1;
            node.nextSibNum = (flags & 8) != 0 ? this.nodeBuf.readInt() : -1;
            assert (node.prevSibNum != node.nextSibNum || node.prevSibNum < 0);
            assert (node.prevSibNum < node.nodeNum);
            assert (node.nextSibNum > node.nodeNum || node.nextSibNum < 0);
            if ((flags & 0x10) != 0) {
                assert (node instanceof ParentNodeImpl);
                ((ParentNodeImpl)node).childNum = this.nodeBuf.readInt();
                assert (((ParentNodeImpl)node).childNum > 0);
            } else if (node instanceof ParentNodeImpl) {
                ((ParentNodeImpl)node).childNum = -1;
            }
            int alpha = -1;
            if ((flags & 0x20) != 0) {
                alpha = this.nodeBuf.readInt();
            }
            int beta = -1;
            if ((flags & 0x40) != 0) {
                beta = this.nodeBuf.readInt();
            }
            node.init(alpha, beta);
            this.nodeCache.put(num, new SoftReference<NodeImpl>(node));
            return node;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected NodeImpl checkCache(int num) {
        SoftReference weak;
        if (this.killCheckCounter++ > 1000) {
            this.killCheckCounter = 0;
            if (ThreadWatcher.shouldDie(Thread.currentThread())) {
                throw new RuntimeException("Runaway request - time limit exceeded");
            }
        }
        Object ref = this.nodeCache.get(num);
        NodeImpl node = null;
        if (ref instanceof NodeImpl) {
            node = (NodeImpl)ref;
        } else if (ref instanceof SoftReference && (node = (NodeImpl)(weak = (SoftReference)ref).get()) == null) {
            this.nodeCache.remove(num);
        }
        return node;
    }

    protected NodeImpl createElementNode() {
        return new ElementImpl();
    }

    protected NodeImpl createTextNode() {
        return new TextImpl();
    }

    public long getSequenceNumber() {
        return 0L;
    }

    public final NodeInfo getNextSibling() {
        return null;
    }

    public final NodeInfo getPreviousSibling() {
        return null;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append('d');
        buffer.append(Integer.toString(this.documentNumber));
    }

    protected boolean isUsingNamespaces() {
        return this.usesNamespaces;
    }

    public void setSystemId(String uri) {
        if (uri == null) {
            uri = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(this.nodeNum, uri);
    }

    public String getSystemId() {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(this.nodeNum);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int seq, String uri) {
        if (uri == null) {
            uri = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(seq, uri);
    }

    protected String getSystemId(int seq) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(seq);
    }

    public void setLineNumbering() {
        assert (false) : "LazyTree does not support line numbering yet";
    }

    protected void setLineNumber(int sequence, int line) {
        assert (false) : "LazyTree does not support line numbering yet";
    }

    protected int getLineNumber(int sequence) {
        assert (false) : "LazyTree does not support line numbering yet";
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getItemType() {
        return 9;
    }

    public NodeInfo getRoot() {
        return this.rootNodeNum == this.nodeNum ? this : this.getNode(this.rootNodeNum);
    }

    public DocumentInfo getDocumentRoot() {
        return this.rootNodeNum == this.nodeNum ? this : null;
    }

    public String generateId() {
        return "d" + this.documentNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AxisIterator getAllElements(int fingerprint) {
        StructuredStore structuredStore = this.mainStore;
        synchronized (structuredStore) {
            String subName = "all-" + this.namePool.getDisplayName(fingerprint);
            try {
                SubStoreReader indexFile = this.mainStore.openSubStore(subName);
                PackedByteBuf buf = new PackedByteBuf(indexFile, (int)indexFile.length());
                int nNodes = buf.readInt();
                ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>(nNodes);
                int curNodeNum = 0;
                for (int i = 0; i < nNodes; ++i) {
                    nodes.add(this.getNode(curNodeNum += buf.readInt()));
                }
                indexFile.close();
                return new NodeListIterator(nodes);
            }
            catch (IOException e) {
                if (this.debug) {
                    Trace.debug("Building list of elements named '" + this.namePool.getDisplayName(fingerprint) + "'.");
                }
                ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>(this.numberOfNodes / 8);
                Vector<Integer> nodeNums = new Vector<Integer>(this.numberOfNodes / 8);
                for (int i = 0; i < this.numberOfNodes; ++i) {
                    NodeImpl node = this.getNode(i);
                    if (node == null || (node.getNameCode() & 0xFFFFF) != fingerprint) continue;
                    nodes.add(node);
                    nodeNums.add(node.nodeNum);
                }
                PackedByteBuf buf = new PackedByteBuf(nodeNums.size() * 3);
                buf.writeInt(nodeNums.size());
                int curNum = 0;
                for (int i = 0; i < nodeNums.size(); ++i) {
                    int num = (Integer)nodeNums.get(i);
                    buf.writeInt(num - curNum);
                    curNum = num;
                }
                try {
                    SubStoreWriter indexFile = this.mainStore.createSubStore(subName);
                    buf.output(indexFile);
                    indexFile.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return new NodeListIterator(nodes);
            }
        }
    }

    public NodeInfo selectID(String id) {
        assert (false) : "LazyTree does not support selectId() yet";
        return null;
    }

    public String[] getUnparsedEntity(String name) {
        assert (false) : "LazyTree does not support unparsed entities yet";
        return null;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        NodeInfo child;
        AxisIterator children = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)children.next()) != null) {
            child.copy(out, whichNamespaces, copyAnnotations, locationId);
        }
    }
}

