/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.HackedTinyBuilder;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.util.ConsecutiveMap;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class LazyTreeBuilder {
    private TinyTree tree;
    private NamePool namePool;
    private ConsecutiveMap names = new ConsecutiveMap();
    private Configuration config;
    private PipelineConfiguration pipe;
    public static final String CURRENT_VERSION = "2.0";
    public static final String REQUIRED_VERSION = "2.0";

    public LazyTreeBuilder(Configuration config) {
        this.config = config;
        config.setErrorListener(new XTFSaxonErrorListener());
        this.pipe = new PipelineConfiguration();
        this.pipe.setConfiguration(config);
        this.pipe.setErrorListener(config.getErrorListener());
    }

    public void setNamePool(NamePool pool) {
        this.namePool = pool;
    }

    public NodeInfo load(StructuredStore treeStore) throws FileNotFoundException, IOException {
        LazyDocument targetDoc = new LazyDocument(this.config);
        this.load(treeStore, targetDoc);
        return targetDoc;
    }

    public void load(StructuredStore treeStore, LazyDocument emptyDoc) throws FileNotFoundException, IOException {
        String fileVer = treeStore.getUserVersion();
        if (fileVer.compareTo("2.0") < 0) {
            throw new IOException("Cannot use old version of LazyTree file... consider re-indexing with '-clean'.");
        }
        emptyDoc.init(this.namePool, treeStore);
        emptyDoc.setSystemId(treeStore.getSystemId());
    }

    public Receiver begin(StructuredStore treeStore) throws IOException {
        HackedTinyBuilder builder = new HackedTinyBuilder();
        if (this.namePool == null) {
            this.namePool = this.config.getNamePool();
        }
        builder.setPipelineConfiguration(this.pipe);
        builder.setTreeStore(treeStore);
        treeStore.setUserVersion("2.0");
        SubStoreWriter textFile = treeStore.createSubStore("text");
        builder.setTextStore(textFile);
        return builder;
    }

    public int getNodeNum(Receiver inBuilder) {
        int nNodes;
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        this.tree = builder.getTree();
        for (nNodes = this.tree.getNumberOfNodes(); nNodes > 0 && this.tree.getNodeKind(nNodes - 1) == 11; --nNodes) {
        }
        return nNodes;
    }

    public void finish(Receiver inBuilder, boolean closeStore) throws IOException {
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        StructuredStore treeStore = builder.getTreeStore();
        this.tree = builder.getTree();
        builder.getTextStore().close();
        builder.setTextStore(null);
        if (this.tree == null) {
            treeStore.delete();
            return;
        }
        this.checkSupport();
        this.writeNames(treeStore.createSubStore("names"));
        this.writeAttrs(treeStore.createSubStore("attributes"));
        this.writeNodes(treeStore.createSubStore("nodes"));
        if (closeStore) {
            treeStore.close();
        }
        this.tree = null;
        this.names = null;
    }

    public void abort(Receiver inBuilder) {
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        try {
            StructuredStore treeStore;
            if (builder.getTextStore() != null) {
                builder.getTextStore().close();
            }
            if ((treeStore = builder.getTreeStore()) != null) {
                treeStore.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNames(SubStoreWriter out) throws IOException {
        PackedByteBuf buf = new PackedByteBuf(1000);
        assert (this.tree.getConfiguration().getNamePool() == this.namePool);
        buf.writeInt(this.tree.getNumberOfNamespaces());
        int[] namespaceCodes = this.tree.getNamespaceCodeArray();
        int[] namespaceParents = this.tree.getNamespaceParentArray();
        for (int i = 0; i < this.tree.getNumberOfNamespaces(); ++i) {
            int code = namespaceCodes[i];
            buf.writeString(this.namePool.getPrefixFromNamespaceCode(code));
            buf.writeString(this.namePool.getURIFromNamespaceCode(code));
            buf.writeInt(namespaceParents[i]);
        }
        int[] nameCodes = this.tree.getNameCodeArray();
        for (int i = 0; i < this.tree.getNumberOfNodes(); ++i) {
            if (nameCodes[i] < 0) continue;
            this.names.put(nameCodes[i]);
        }
        int[] attCodes = this.tree.getAttributeNameCodeArray();
        for (int i = 0; i < this.tree.getNumberOfAttributes(); ++i) {
            if (attCodes[i] < 0) continue;
            this.names.put(attCodes[i]);
        }
        Object[] nameArray = this.names.getArray();
        buf.writeInt(nameArray.length);
        for (int i = 0; i < nameArray.length; ++i) {
            int code = (Integer)nameArray[i];
            buf.writeString(this.namePool.getPrefix(code));
            buf.writeString(this.namePool.getURI(code));
            buf.writeString(this.namePool.getLocalName(code));
        }
        buf.output(out);
        out.close();
    }

    private void writeNodes(SubStoreWriter out) throws IOException {
        int i;
        int nNodes;
        out.writeInt(0);
        for (nNodes = this.tree.getNumberOfNodes(); nNodes > 0 && this.tree.getNodeKind(nNodes - 1) == 11; --nNodes) {
        }
        int[] nameCodes = this.tree.getNameCodeArray();
        int[] nexts = this.tree.getNextPointerArray();
        int[] alphas = this.tree.getAlphaArray();
        int[] betas = this.tree.getBetaArray();
        int[] prior = new int[this.tree.getNumberOfNodes()];
        Arrays.fill(prior, 0, this.tree.getNumberOfNodes(), -1);
        for (int i2 = 0; i2 < this.tree.getNumberOfNodes(); ++i2) {
            int nextNode = nexts[i2];
            if (nextNode <= i2) continue;
            prior[nextNode] = i2;
        }
        PackedByteBuf[] nodeBufs = new PackedByteBuf[nNodes];
        int maxSize = 0;
        for (i = 0; i < nNodes; ++i) {
            PackedByteBuf buf = nodeBufs[i] = new PackedByteBuf(20);
            byte kind = this.tree.nodeKind[i];
            if (kind == 8 || kind == 7) {
                throw new RuntimeException("Internal error: processing instructions and comments should have been filtered out");
            }
            buf.writeByte(this.tree.nodeKind[i]);
            TinyNodeImpl node = this.tree.getNode(i);
            int nameCode = nameCodes[i];
            int parent = node.getParent() != null ? ((TinyNodeImpl)node.getParent()).getNodeNumber() : -1;
            int prevSib = prior[i];
            int nextSib = nexts[i] > i ? nexts[i] : -1;
            int child = node.hasChildNodes() ? i + 1 : -1;
            int alpha = alphas[i];
            int beta = betas[i];
            int flags = (nameCode != -1 ? 1 : 0) | (parent != -1 ? 2 : 0) | (prevSib != -1 ? 4 : 0) | (nextSib != -1 ? 8 : 0) | (child != -1 ? 16 : 0) | (alpha != -1 ? 32 : 0) | (beta != -1 ? 64 : 0);
            buf.writeInt(flags);
            assert (prevSib != nextSib || prevSib < 0);
            if (nameCode >= 0) {
                int nameIdx = this.names.get(nameCode);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
            }
            if (parent >= 0) {
                buf.writeInt(parent);
            }
            if (prevSib >= 0) {
                buf.writeInt(prevSib);
            }
            if (nextSib >= 0) {
                buf.writeInt(nextSib);
            }
            if (child >= 0) {
                assert (child != 0);
                buf.writeInt(child);
            }
            if (alpha != -1) {
                buf.writeInt(alpha);
            }
            if (beta != -1) {
                buf.writeInt(beta);
            }
            buf.compact();
            maxSize = Math.max(maxSize, buf.length());
        }
        out.writeInt(this.tree.getNumberOfNodes());
        out.writeInt(maxSize);
        for (i = 0; i < nNodes; ++i) {
            nodeBufs[i].output(out, maxSize);
        }
        out.close();
    }

    private void writeAttrs(SubStoreWriter out) throws IOException {
        int nAttrs;
        int nAttrs2;
        int maxSize = 0;
        PackedByteBuf buf = new PackedByteBuf(100);
        int[] attParents = this.tree.getAttributeParentArray();
        int[] attCodes = this.tree.getAttributeNameCodeArray();
        CharSequence[] attValues = this.tree.getAttributeValueArray();
        for (int i = 0; i < this.tree.getNumberOfAttributes(); i += nAttrs2) {
            int j;
            for (j = i + 1; j < this.tree.getNumberOfAttributes() && attParents[j] == attParents[i]; ++j) {
            }
            nAttrs2 = j - i;
            buf.reset();
            buf.writeInt(nAttrs2);
            for (j = i; j < i + nAttrs2; ++j) {
                int nameIdx = this.names.get(attCodes[j]);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
                buf.writeString(((Object)attValues[j]).toString());
            }
            maxSize = Math.max(maxSize, buf.length());
        }
        out.writeInt(maxSize);
        int[] alphas = this.tree.getAlphaArray();
        for (int i = 0; i < this.tree.getNumberOfAttributes(); i += nAttrs) {
            int j;
            for (j = i + 1; j < this.tree.getNumberOfAttributes() && attParents[j] == attParents[i]; ++j) {
            }
            nAttrs = j - i;
            buf.reset();
            buf.writeInt(nAttrs);
            for (j = i; j < i + nAttrs; ++j) {
                int nameIdx = this.names.get(attCodes[j]);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
                buf.writeString(((Object)attValues[j]).toString());
            }
            int parent = attParents[i];
            assert (this.tree.nodeKind[parent] == 1);
            alphas[parent] = (int)out.length();
            buf.output(out);
        }
        byte[] tmp = new byte[maxSize];
        out.write(tmp);
        out.close();
    }

    private void checkSupport() throws IOException {
        if (this.tree.getAttributeTypeCodeArray() != null || this.tree.getTypeCodeArray() != null) {
            // empty if block
        }
    }
}

