/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.IOException;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.cdlib.xtf.lazyTree.AncestorEnumeration;
import org.cdlib.xtf.lazyTree.AttributeEnumeration;
import org.cdlib.xtf.lazyTree.DescendantEnumeration;
import org.cdlib.xtf.lazyTree.FollowingEnumeration;
import org.cdlib.xtf.lazyTree.FollowingSiblingEnumeration;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.ParentNodeImpl;
import org.cdlib.xtf.lazyTree.PrecedingEnumeration;
import org.cdlib.xtf.lazyTree.PrecedingOrAncestorEnumeration;
import org.cdlib.xtf.lazyTree.PrecedingSiblingEnumeration;

public abstract class NodeImpl
implements NodeInfo,
FingerprintedNode,
SourceLocator {
    LazyDocument document;
    int nodeNum;
    int nameCode;
    int parentNum;
    int prevSibNum;
    int nextSibNum;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getTypeAnnotation() {
        return 630;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public int getDocumentNumber() {
        return this.getRoot().getDocumentNumber();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValue()));
    }

    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValue());
    }

    public void setSystemId(String uri) {
        this.getParent().setSystemId(uri);
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeImpl)) {
            return false;
        }
        if (this.document != ((NodeImpl)other).document) {
            return false;
        }
        if (this.nodeNum != ((NodeImpl)other).nodeNum) {
            return false;
        }
        return this.getNodeKind() == other.getNodeKind();
    }

    public boolean equals(Object other) {
        if (other instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)other);
        }
        return false;
    }

    public int hashCode() {
        FastStringBuffer buff = new FastStringBuffer(20);
        this.generateId(buff);
        return buff.toString().hashCode();
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return -1;
        }
        return nameCode & 0xFFFFF;
    }

    public void generateId(FastStringBuffer buffer) {
        this.getDocumentRoot().generateId(buffer);
        buffer.append(NODE_LETTER[this.getNodeKind()]);
        buffer.append(Long.toString(this.getSequenceNumber()));
    }

    public String getSystemId() {
        return this.getParent().getSystemId();
    }

    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNum << 32;
    }

    public int compareOrder(NodeInfo other) {
        long b;
        if (other instanceof NamespaceIterator.NamespaceNodeImpl) {
            return 0 - other.compareOrder(this);
        }
        long a = this.getSequenceNumber();
        if (a < (b = ((NodeImpl)other).getSequenceNumber())) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public Configuration getConfiguration() {
        return this.getDocumentRoot().getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getDocumentRoot().getNamePool();
    }

    public String getPrefix() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        if (NamePool.getPrefixIndex(nameCode) == 0) {
            return "";
        }
        return this.getNamePool().getPrefix(nameCode);
    }

    public String getURI() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getURI(nameCode);
    }

    public String getDisplayName() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getDisplayName(nameCode);
    }

    public String getLocalPart() {
        int nameCode = this.getNameCode();
        if (nameCode == -1) {
            return "";
        }
        return this.getNamePool().getLocalName(nameCode);
    }

    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }

    public NodeInfo getParent() {
        return this.document.getNode(this.parentNum);
    }

    public NodeInfo getPreviousSibling() {
        return this.document.getNode(this.prevSibNum);
    }

    public NodeInfo getNextSibling() {
        return this.document.getNode(this.nextSibNum);
    }

    public NodeInfo getFirstChild() {
        return null;
    }

    public NodeInfo getLastChild() {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            if (this instanceof ParentNodeImpl) {
                return ((ParentNodeImpl)this).enumerateChildren(null);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this, nodeTest);
            }
            case 3: {
                if (this instanceof ParentNodeImpl) {
                    return ((ParentNodeImpl)this).enumerateChildren(nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.getNodeKind() == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((LazyDocument)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new DescendantEnumeration(this, nodeTest, true);
            }
            case 6: {
                return new FollowingEnumeration(this, nodeTest);
            }
            case 7: {
                return new FollowingSiblingEnumeration(this, nodeTest);
            }
            case 8: {
                if (this.getNodeKind() != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo parent = this.getParent();
                if (parent == null) {
                    return EmptyIterator.getInstance();
                }
                return Navigator.filteredSingleton(parent, nodeTest);
            }
            case 10: {
                return new PrecedingEnumeration(this, nodeTest);
            }
            case 11: {
                return new PrecedingSiblingEnumeration(this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new PrecedingOrAncestorEnumeration(this, nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.getDocumentRoot();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getParent().getDocumentRoot();
    }

    public NodeImpl getNextInDocument(NodeImpl anchor) {
        NodeImpl next = (NodeImpl)this.getFirstChild();
        if (next != null) {
            return next;
        }
        if (this == anchor) {
            return null;
        }
        next = (NodeImpl)this.getNextSibling();
        if (next != null) {
            return next;
        }
        NodeImpl parent = this;
        do {
            if ((parent = (NodeImpl)parent.getParent()) == null) {
                return null;
            }
            if (parent != anchor) continue;
            return null;
        } while ((next = (NodeImpl)parent.getNextSibling()) == null);
        return next;
    }

    public NodeImpl getPreviousInDocument() {
        NodeImpl prev = (NodeImpl)this.getPreviousSibling();
        if (prev != null) {
            return prev.getLastDescendantOrSelf();
        }
        return (NodeImpl)this.getParent();
    }

    private NodeImpl getLastDescendantOrSelf() {
        NodeImpl last = (NodeImpl)this.getLastChild();
        if (last == null) {
            return this;
        }
        return last.getLastDescendantOrSelf();
    }

    public void sendNamespaceDeclarations(Receiver out, boolean includeAncestors) throws XPathException {
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public void init(int alpha, int beta) throws IOException {
    }
}

