/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import org.cdlib.xtf.util.Trace;

public class ProfilingListener
implements TraceListener {
    private ThreadLocal tlInstructionStack = new ThreadLocal();
    private static final ProfileCount emptyInstr = new ProfileCount("[Global variables]", 0);
    private ThreadLocal tlCountMap = new ThreadLocal();

    public void open() {
    }

    public void close() {
    }

    private LinkedList getInstructionStack() {
        LinkedList stack = (LinkedList)this.tlInstructionStack.get();
        if (stack == null) {
            stack = new LinkedList();
            this.tlInstructionStack.set(stack);
        }
        return stack;
    }

    private HashMap getCountMap() {
        HashMap map = (HashMap)this.tlCountMap.get();
        if (map == null) {
            map = new HashMap();
            this.tlCountMap.set(map);
        }
        return map;
    }

    public void enter(InstructionInfo instruction, XPathContext context) {
        LinkedList instructionStack = this.getInstructionStack();
        instructionStack.addLast(new ProfileCount(instruction.getSystemId(), instruction.getLineNumber()));
    }

    public void leave(InstructionInfo instruction) {
        LinkedList instructionStack = this.getInstructionStack();
        assert (!instructionStack.isEmpty());
        instructionStack.removeLast();
    }

    public void startCurrentItem(Item currentItem) {
    }

    public void endCurrentItem(Item currentItem) {
    }

    public void bumpCount(int nodeNum) {
        ProfileCount instr;
        LinkedList instructionStack = this.getInstructionStack();
        HashMap countMap = this.getCountMap();
        ProfileCount pc = (ProfileCount)countMap.get(instr = instructionStack.isEmpty() ? emptyInstr : (ProfileCount)instructionStack.getLast());
        if (pc == null) {
            pc = new ProfileCount(instr.systemId, instr.lineNum);
            countMap.put(instr, pc);
        }
        if (!pc.nodes.containsKey(nodeNum)) {
            ++pc.count;
            pc.nodes.put(nodeNum, Boolean.TRUE);
        }
    }

    public ProfileCount[] getCounts() {
        HashMap countMap = this.getCountMap();
        ArrayList list = new ArrayList(countMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ProfileCount p1 = (ProfileCount)o1;
                ProfileCount p2 = (ProfileCount)o2;
                if (p1.count != p2.count) {
                    return p1.count - p2.count;
                }
                if (!p1.systemId.equals(p2.systemId)) {
                    return p1.systemId.compareTo(p2.systemId);
                }
                return p1.lineNum - p2.lineNum;
            }
        });
        ProfileCount[] array = new ProfileCount[list.size()];
        list.toArray(array);
        countMap.clear();
        return array;
    }

    public void printProfile() throws IOException {
        ProfileCount[] counts = this.getCounts();
        for (int i = counts.length - 1; i >= 0; --i) {
            Trace.info(counts[i].count + " " + counts[i].systemId + ":" + counts[i].lineNum);
        }
    }

    public static class ProfileCount {
        public String systemId;
        public int lineNum;
        public int count;
        public HashMap nodes = new HashMap();

        public ProfileCount() {
        }

        public ProfileCount(String systemId, int lineNum) {
            this.systemId = systemId;
            this.lineNum = lineNum;
        }

        public int hashCode() {
            if (this.systemId != null) {
                return this.lineNum ^ this.systemId.hashCode();
            }
            return this.lineNum;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProfileCount)) {
                return false;
            }
            ProfileCount p = (ProfileCount)other;
            return p.systemId == this.systemId && p.lineNum == this.lineNum;
        }
    }
}

