/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import org.cdlib.xtf.lazyTree.ProxyAttributeImpl;
import org.cdlib.xtf.lazyTree.ProxyElement;

final class ProxyAttributeEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private ProxyElement element;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public ProxyAttributeEnumeration(ProxyElement element, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (element.attrNames == null) {
            return;
        }
        if (nodeTest instanceof NameTest) {
            NameTest test = (NameTest)nodeTest;
            int fingerprint = test.getFingerprint();
            for (int i = 0; i < element.attrNames.length; ++i) {
                if ((element.attrNames[i] & 0xFFFFF) != fingerprint) continue;
                this.next = new ProxyAttributeImpl(element, i);
                return;
            }
            this.next = null;
        } else {
            this.length = element.attrNames.length;
            this.advance();
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() {
        if (this.next == null) {
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            if (this.index < this.length) {
                this.next = new ProxyAttributeImpl(this.element, this.index);
                ++this.index;
                continue;
            }
            this.next = null;
            return;
        } while (!this.nodeTest.matches(this.next.getNodeKind(), this.next.getFingerprint(), this.next.getTypeAnnotation()));
    }

    public SequenceIterator getAnother() {
        return new ProxyAttributeEnumeration(this.element, this.nodeTest);
    }
}

