/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.lazyTree.ElementImpl;
import org.cdlib.xtf.lazyTree.NodeImpl;
import org.cdlib.xtf.lazyTree.SearchElement;
import org.cdlib.xtf.lazyTree.SearchTree;

public class SearchElementImpl
extends ElementImpl
implements SearchElement {
    boolean specialAttrChecked = false;

    SearchElementImpl(SearchTree tree) {
        this.nameSpace = -1;
        this.childNum = -1;
        this.nextSibNum = -1;
        this.prevSibNum = -1;
        this.document = tree;
    }

    public void setNodeNum(int nodeNum) {
        this.nodeNum = nodeNum;
    }

    public void allocateAttributes(int nAttrs) {
        this.attrNames = new int[nAttrs];
        this.attrValues = new String[nAttrs];
    }

    public void setAttribute(int attrNum, int nameCode, String value) {
        this.attrNames[attrNum] = nameCode;
        this.attrValues[attrNum] = value;
    }

    public void setParentNum(int parentNum) {
        this.parentNum = parentNum;
    }

    public void setChildNum(int num) {
        this.childNum = num;
    }

    public void setNextSibNum(int num) {
        this.nextSibNum = num;
    }

    public void setPrevSibNum(int num) {
        this.prevSibNum = num;
    }

    public void setNameCode(int code) {
        this.nameCode = code;
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (axisNumber == 2) {
            this.addSpecialAttrib();
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        this.addSpecialAttrib();
        return super.getAttributeValue(fingerprint);
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        this.addSpecialAttrib();
        super.copy(out, whichNamespaces, copyAnnotations, locationId);
    }

    private void addSpecialAttrib() {
        if (this.specialAttrChecked) {
            return;
        }
        this.specialAttrChecked = true;
        if (this.nodeNum >= 1000000000) {
            return;
        }
        SearchTree tree = (SearchTree)this.document;
        int firstHit = tree.findFirstHit(this.nodeNum);
        int lastHit = tree.findLastHit(this.nodeNum);
        int count = lastHit - firstHit;
        if (count == 0 && this.nodeNum > 1) {
            return;
        }
        int nAttrs = this.attrNames != null ? this.attrNames.length : 0;
        int[] names2 = new int[nAttrs + 2];
        if (this.attrNames != null) {
            System.arraycopy(this.attrNames, 0, names2, 0, nAttrs);
        }
        this.attrNames = names2;
        String[] values2 = new String[nAttrs + 2];
        if (this.attrValues != null) {
            System.arraycopy(this.attrValues, 0, values2, 0, nAttrs);
        }
        this.attrValues = values2;
        this.attrNames[nAttrs] = tree.xtfHitCountAttrCode;
        this.attrValues[nAttrs] = Integer.toString(count);
        this.attrNames[++nAttrs] = tree.xtfFirstHitAttrCode;
        this.attrValues[nAttrs] = Integer.toString(firstHit + 1);
        ++nAttrs;
    }

    protected long getSequenceNumber() {
        if (this.nodeNum <= 1400000000) {
            return super.getSequenceNumber();
        }
        NodeImpl node = this;
        int count = 0;
        while ((node = node.getPreviousInDocument()) != null) {
            ++count;
            if (node.nodeNum > 1400000000) continue;
            return node.getSequenceNumber() + (long)(count << 16);
        }
        assert (false) : "Virtual node must be preceeded by some real node";
        return 0L;
    }

    public void sendNamespaceDeclarations(Receiver out, boolean includeAncestors) throws XPathException {
        super.sendNamespaceDeclarations(out, includeAncestors);
        if (this.nodeNum <= 1) {
            out.namespace(((SearchTree)this.document).xtfNamespaceCode, 0);
        }
    }
}

