/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstructionWithContent
extends Instruction {
    protected final String name;
    private int nameCode;
    protected Map<String, Expression> attribs;
    protected Expression content;

    public InstructionWithContent(String name, Map<String, Expression> attribs, Expression content) {
        this.name = name;
        this.attribs = attribs;
        this.content = content;
        for (Expression exp : attribs.values()) {
            this.adoptChildExpression(exp);
        }
        this.adoptChildExpression(content);
    }

    @Override
    public Expression simplify(StaticContext env) throws XPathException {
        for (Map.Entry<String, Expression> attrib : this.attribs.entrySet()) {
            attrib.setValue(attrib.getValue().simplify(env));
        }
        if (this.content != null) {
            this.content = this.content.simplify(env);
        }
        return this;
    }

    @Override
    public Expression typeCheck(StaticContext env, ItemType contextItemType) throws XPathException {
        for (Map.Entry<String, Expression> attrib : this.attribs.entrySet()) {
            attrib.setValue(attrib.getValue().typeCheck(env, contextItemType));
            this.adoptChildExpression(attrib.getValue());
        }
        if (this.content != null) {
            this.content = this.content.typeCheck(env, contextItemType);
            this.adoptChildExpression(this.content);
        }
        return this;
    }

    @Override
    public Expression optimize(Optimizer opt, StaticContext env, ItemType contextItemType) throws XPathException {
        for (Map.Entry<String, Expression> attrib : this.attribs.entrySet()) {
            Expression exp = attrib.getValue();
            exp = exp.optimize(opt, env, contextItemType);
            attrib.setValue(exp);
            this.adoptChildExpression(exp);
        }
        if (this.content != null) {
            this.content = this.content.optimize(opt, env, contextItemType);
            this.adoptChildExpression(this.content);
        }
        return this;
    }

    @Override
    public int getInstructionNameCode() {
        return this.nameCode;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public int getCardinality() {
        return 8192;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        for (Map.Entry<String, Expression> attrib : this.attribs.entrySet()) {
            Expression exp = attrib.getValue();
            if (exp == null) continue;
            exp = this.doPromotion(exp, offer);
            attrib.setValue(exp);
        }
        if (this.content != null) {
            this.content = this.doPromotion(this.content, offer);
        }
    }

    @Override
    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(this.attribs.size() + 1);
        for (Expression exp : this.attribs.values()) {
            list.add(exp);
        }
        if (this.content != null) {
            list.add(this.content);
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (Map.Entry<String, Expression> attrib : this.attribs.entrySet()) {
            Expression exp = attrib.getValue();
            if (exp != original) continue;
            attrib.setValue(replacement);
            found = true;
        }
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public abstract TailCall processLeavingTail(XPathContext var1) throws XPathException;

    protected static String sequenceToString(Expression exp, XPathContext context) throws XPathException {
        Item item;
        StringBuffer buf = new StringBuffer();
        SequenceIterator iter = exp.iterate(context);
        while ((item = iter.next()) != null) {
            buf.append(item.getStringValue());
        }
        return buf.toString();
    }

    @Override
    public void display(int level, PrintStream out, Configuration config) {
        out.println(ExpressionTool.indent(level) + this.name);
    }
}

