/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionElementFactory;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.servletBase.TextServlet;

public class Redirect
implements ExtensionElementFactory {
    public Class getExtensionClass(String localname) {
        if (localname.equals("send")) {
            return SendElement.class;
        }
        return null;
    }

    public static class SendElement
    extends ExtensionInstruction {
        Expression urlExp;

        public void prepareAttributes() throws XPathException {
            String urlAtt = this.getAttributeList().getValue("", "url");
            if (urlAtt == null) {
                this.reportAbsence("url");
                return;
            }
            this.urlExp = this.makeAttributeValueTemplate(urlAtt);
        }

        public Expression compile(Executable exec) throws XPathException {
            return new SendInstruction(this.urlExp);
        }

        private class SendInstruction
        extends SimpleExpression {
            Expression urlExp;

            public SendInstruction(Expression urlExp) {
                this.urlExp = urlExp;
            }

            public int getImplementationMethod() {
                return 1;
            }

            public String getExpressionType() {
                return "redirect:send";
            }

            public Item evaluateItem(XPathContext context) throws XPathException {
                HttpServletResponse res = TextServlet.getCurResponse();
                String url = this.urlExp.evaluateAsString(context);
                String encodedUrl = res.encodeRedirectURL(url);
                try {
                    res.sendRedirect(encodedUrl);
                }
                catch (IOException e) {
                    throw new DynamicError(e);
                }
                return null;
            }
        }
    }
}

